#' Euclidean distance
#'
#' This function calculates the euclidean distance between two vectors
#'
#' @param vect1 vector
#' @param vect2 vector
#'
#'
#'@returns A number with the distance between \code{vect1} and \code{vect2}.
#'
#'
#'@examples
#'
#'   Euclideandistance(c(1,2,3), c(4,5,6))
#'
#' @export

Euclideandistance<- function(vect1, vect2){
    sqrt(sum((vect1-vect2)^2))
  }
