set.seed(231)
data12=gtools::rdirichlet(10,c(1,1,4,4,20,20))
data1=t(data12)
k=3
seed=5
index=0

distance<- function(vect1, vect2){
  sqrt(sum((vect1-vect2)^2))
}

centers_function<-function(data, grouping){
  center=matrix(0,length(grouping), dim(data)[2])
  for (i in 1:(length(grouping))){

    if(length(grouping[[i]])==1){
      center[i,]=data[grouping[[i]],]
    }else{
      center[i,]=apply(data[grouping[[i]],],2,mean)
    }
  }
  return(center)
}



if(!is.null(seed)){
  set.seed(seed)
}
centers <- data1[sample(1:nrow(data1), k), ]


#Step 1.
Dist_e_cent=matrix(0,dim(data1)[1],dim(centers)[1])
for (i in 1:(dim(data1)[1])){
  for (j in 1:(dim(centers)[1])){
    Dist_e_cent[i,j]=distance(data1[i,],centers[j,])
  }
}

Ic12_change=Dist_IC1_IC2(Dist_e_cent)

Group=Ic12_change[,1]
grouping<-list()
for(i in 1:(max(Group))){
  grouping[[i]]=which(Group==i)#list with the number of the rows of the data matrix that are in the group [[i]]
}

#Step 2. Update the clusters centers.
centers=centers_function(data1, grouping)

Ic12=cbind(c(1,1,3,3,2,2),c(1,2,1,2,3,3))



P1=Step6(data1, centers, grouping, distance, centers_function, Ic12_change,Ic12,index)

####################Another test
rm(list=ls()[! ls() %in% c("P1","data1")])
#####################
set.seed(231)
data11=gtools::rdirichlet(10,c(1,1,1,4,4,4,20,20,20))
data2=t(data11)
k=3
seed=5
index=0

distance<- function(vect1, vect2){
  sqrt(sum((vect1-vect2)^2))
}

centers_function<-function(data, grouping){
  center=matrix(0,length(grouping), dim(data)[2])
  for (i in 1:(length(grouping))){

    if(length(grouping[[i]])==1){
      center[i,]=data[grouping[[i]],]
    }else{
      center[i,]=apply(data[grouping[[i]],],2,mean)
    }
  }
  return(center)
}



if(!is.null(seed)){
  set.seed(seed)
}
centers <- data2[sample(1:nrow(data2), k), ]


#Step 1.
Dist_e_cent=matrix(0,dim(data2)[1],dim(centers)[1])
for (i in 1:(dim(data2)[1])){
  for (j in 1:(dim(centers)[1])){
    Dist_e_cent[i,j]=distance(data2[i,],centers[j,])
  }
}


Ic12_change=Dist_IC1_IC2(Dist_e_cent)

Group=Ic12_change[,1]
grouping<-list()
for(i in 1:(max(Group))){
  grouping[[i]]=which(Group==i)#list with the number of the rows of the data matrix that are in the group [[i]]
}

#Step 2. Update the clusters centers.
centers=centers_function(data2, grouping)


Ic12=cbind(c(2,1,3,3,2,2,3,3,3),c(1,2,2,1,3,3,2,2,2))


P2=Step6(data2, centers, grouping, distance, centers_function, Ic12_change,Ic12,index)

listfinal=list(c(2,1,3),c(5,6,4), c(7,8,9))
listfinal2=list(c(2,1),c(5,6),c(4,3))



test_that("Step6", {
  expect_equal(dim(P1$centers)[1], k,tolerance=1e-6)
  expect_equal(dim(P1$centers)[2], dim(data1)[2],tolerance=1e-6)
  expect_equal(dim(P2$centers)[1], k,tolerance=1e-6)
  expect_equal(dim(P2$centers)[2], dim(data2)[2],tolerance=1e-6)

  expect_equal(dim(P1$IC1andIC2)[1], dim(data1)[1],tolerance=1e-6)
  expect_equal(dim(P1$IC1andIC2)[2], 2,tolerance=1e-6)
  expect_equal(dim(P2$IC1andIC2)[1], dim(data2)[1],tolerance=1e-6)
  expect_equal(dim(P2$IC1andIC2)[2], 2,tolerance=1e-6)

  expect_equal(P1$grouping, listfinal2,tolerance=1e-6)
  expect_equal(P2$grouping, listfinal,tolerance=1e-6)

  expect_equal(max(P1$Live_set)<=k, TRUE,tolerance=1e-6)
  expect_equal(max(P2$Live_set)<=k, TRUE,tolerance=1e-6)

  expect_equal(P1$index, 0,tolerance=1e-6)
  expect_equal(P2$index, 0,tolerance=1e-6)
})



