% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dist_macg.R
\name{macg}
\alias{macg}
\alias{dmacg}
\alias{rmacg}
\alias{mle.macg}
\title{Matrix Angular Central Gaussian Distribution}
\usage{
dmacg(datalist, Sigma)

rmacg(n, r, Sigma)

mle.macg(datalist, ...)
}
\arguments{
\item{datalist}{a list of \eqn{(p\times r)} orthonormal matrices.}

\item{Sigma}{a \eqn{(p\times p)} symmetric positive-definite matrix.}

\item{n}{the number of samples to be generated.}

\item{r}{the number of basis.}

\item{...}{extra parameters for computations, including\describe{
\item{maxiter}{maximum number of iterations to be run (default:50).}
\item{eps}{tolerance level for stopping criterion (default: 1e-5).}
}}
}
\value{
\code{dmacg} gives a vector of evaluated densities given samples. \code{rmacg} generates  
\eqn{(p\times r)} orthonormal matrices wrapped in a list. \code{mle.macg} estimates 
the SPD matrix \eqn{\Sigma}.
}
\description{
For Stiefel and Grassmann manifolds \eqn{St(r,p)} and \eqn{Gr(r,p)}, the matrix 
variant of ACG distribution is known as Matrix Angular Central Gaussian (MACG) 
distribution \eqn{MACG_{p,r}(\Sigma)} with density
\deqn{f(X\vert \Sigma) = |\Sigma|^{-r/2} |X^\top \Sigma^{-1} X|^{-p/2}}
where \eqn{\Sigma} is a \eqn{(p\times p)} symmetric positive-definite matrix. 
Similar to vector-variate ACG case, we follow a convention that \eqn{tr(\Sigma)=p}.
}
\examples{
# -------------------------------------------------------------------
#          Example with Matrix Angular Central Gaussian Distribution
#
# Given a fixed Sigma, generate samples and estimate Sigma via ML.
# -------------------------------------------------------------------
## GENERATE AND MLE in St(2,5)/Gr(2,5)
#  Generate data
Strue = diag(5)                  # true SPD matrix
sam1  = rmacg(n=50,  r=2, Strue) # random samples
sam2  = rmacg(n=100, r=2, Strue) # random samples

#  MLE
Smle1 = mle.macg(sam1)
Smle2 = mle.macg(sam2)

#  Visualize
opar <- par(no.readonly=TRUE)
par(mfrow=c(1,3), pty="s")
image(Strue[,5:1], axes=FALSE, main="true SPD")
image(Smle1[,5:1], axes=FALSE, main="MLE with n=50")
image(Smle2[,5:1], axes=FALSE, main="MLE with n=100")
par(opar)

}
\references{
\insertRef{chikuse_matrix_1990}{Riemann}

\insertRef{mardia_directional_1999}{Riemann}

Kent JT, Ganeiber AM, Mardia KV (2013). "A new method to simulate the Bingham and related distributions in directional data analysis with applications." \emph{arXiv:1310.8110}.
}
\seealso{
\code{\link{acg}}
}
\concept{distribution}
