% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trial_sequence.R
\name{set_switch_weight_model}
\alias{set_switch_weight_model}
\alias{set_switch_weight_model,trial_sequence-method}
\alias{set_switch_weight_model,trial_sequence_ITT-method}
\title{Set switching weight model}
\usage{
set_switch_weight_model(object, numerator, denominator, model_fitter, ...)

\S4method{set_switch_weight_model}{trial_sequence}(
  object,
  numerator,
  denominator,
  model_fitter,
  eligible_wts_0 = NULL,
  eligible_wts_1 = NULL
)

\S4method{set_switch_weight_model}{trial_sequence_ITT}(object, numerator, denominator, model_fitter)
}
\arguments{
\item{object}{A \link{trial_sequence} object.}

\item{numerator}{Right hand side formula for the numerator model}

\item{denominator}{Right hand side formula for the denominator model}

\item{model_fitter}{A \linkS4class{te_model_fitter} object, such as \link{stats_glm_logit}}

\item{...}{Other arguments used by methods.}

\item{eligible_wts_0}{Name of column containing indicator (0/1) for observation to be excluded/included in weight
model.}

\item{eligible_wts_1}{Exclude some observations when fitting the models for the inverse probability of treatment
weights. For example, if it is assumed that an individual will stay on treatment for at least 2 visits, the first 2
visits after treatment initiation by definition have a probability of staying on the treatment of 1.0 and should
thus be excluded from the weight models for those who are on treatment at the immediately previous visit. Users can
define a variable that indicates that these 2 observations are ineligible for the weight model for those who are on
treatment at the immediately previous visit and add the variable name in the argument \code{eligible_wts_1}. Similar
definitions are applied to \code{eligible_wts_0} for excluding observations when fitting the models for the inverse
probability of treatment weights for those who are not on treatment at the immediately previous visit.}
}
\value{
\code{object} is returned with \verb{@switch_weights} set
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
}
\examples{
trial_sequence("PP") |>
  set_data(data = data_censored) |>
  set_switch_weight_model(
    numerator = ~ age_s + x1 + x3,
    denominator = ~ x3 + x4,
    model_fitter = stats_glm_logit(tempdir())
  )
}
