% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Juggler.R
\name{Juggler}
\alias{Juggler}
\alias{A094683}
\title{Juggler sequence}
\usage{
Juggler(start, gmp = TRUE)
}
\arguments{
\item{start}{the starting nonnegative integer.}

\item{gmp}{a logical; \code{TRUE} to use large number representation, \code{FALSE} otherwise.}
}
\value{
a vector recording the sequence of unknown length a priori.
}
\description{
Under OEIS \href{https://oeis.org/A094683}{A094683}, a \emph{Juggler} sequence is an integer-valued
sequence that starts with a nonnegative number iteratively follows that \eqn{J_{k+1}=floor(J_k^{1/2})} if \eqn{J_k} is even, or \eqn{J_{k+1}=floor(J_k^{3/2})} if odd.
No first 6 terms are given since it all depends on the starting value.
}
\examples{
## let's start from 9 and show the sequence
print(Juggler(9))

}
