% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/export.R
\name{export_abnFit_mle_nodes}
\alias{export_abnFit_mle_nodes}
\title{Export node information from abnFit objects fitted with MLE (non-mixed effects)}
\usage{
export_abnFit_mle_nodes(object, ...)
}
\arguments{
\item{object}{An object of class abnFit fitted with method = "mle"}

\item{...}{Additional arguments (currently unused)}
}
\value{
A named list with two components: variables and parameters.
Variables is an array where each element represents a variable with its metadata.
Parameters is an array where each element represents a parameter with its coefficients.
}
\description{
Export node information from abnFit objects fitted with MLE (non-mixed effects)
}
\details{
This function extracts node parameterisation information from abnFit objects
that were fitted using the Maximum Likelihood Estimation (MLE) approach without
mixed-effects (i.e., no group.var specified). The function processes the coefficients
and standard errors stored in the abnFit object.

The \code{coef} component contains the estimated regression coefficients for each node,
stored as a matrix where column names indicate the parameter names (e.g., "g2",
"m11", "b1|intercept"). These represent the linear model coefficients from the
generalized linear model fitted to each node given its parents in the DAG.

The \code{Stderror} component contains the corresponding standard errors for each
coefficient, providing a measure of uncertainty in the parameter estimates. The
structure mirrors that of the \code{coef} component.

For different distribution types:
\itemize{
\item Gaussian nodes: Include intercept and slope coefficients
\item Binomial/Poisson nodes: Include intercept and slope coefficients on logit/log scale
\item Multinomial nodes: Include category-specific intercepts (reference level omitted)
and coefficients, following standard multinomial logistic regression conventions
}
}
\keyword{internal}
