% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimateAWC.R
\name{correctAWC}
\alias{correctAWC}
\title{Apply rock fragment or salt correction to available water content}
\usage{
correctAWC(
  awc,
  total_rf = numeric(length(awc)),
  gravel = NULL,
  ec = NULL,
  nullFragsAreZero = TRUE
)
}
\arguments{
\item{awc}{Numeric vector of available water capacities (e.g. from \code{estimateAWC})}

\item{total_rf}{Numeric vector  of rock fragment volume percentage, 0 - 100}

\item{gravel}{Numeric vector of gravel volume percentage, 0 - 100}

\item{ec}{Numeric vector of electrical conductivity, mmhos/cm}

\item{nullFragsAreZero}{Interpret \code{NA} in \code{total_rf}, \code{gravel} or \code{ec} as \code{0}? Default: \code{TRUE}}
}
\value{
A numeric vector (double) containing estimated available water capacities corrected for rock fragments and salts
}
\description{
Apply rock fragment or salt correction to available water content
}
\examples{

# medium organic matter, loam texture 
base.awc <- 0.18 # estimateAWC(texcl = "l", omcl = 2, na.rm = TRUE)

# medium organic matter, loam texture w/ 23\% rock fragments by volume 
corrected.awc <- correctAWC(base.awc, total_rf = 23)
corrected.awc

# medium organic matter, loam texture w/ 0\% frags by volume and 8 mmhos/cm salts
salty.awc <- correctAWC(base.awc, total_rf = 0, ec = 8)
salty.awc
}
