% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flagOverlappingHz.R
\name{flagOverlappingHz}
\alias{flagOverlappingHz}
\title{Flag perfectly overlapping horizons within a SoilProfileCollection}
\usage{
flagOverlappingHz(x)
}
\arguments{
\item{x}{a \code{SoilProfileCollection} object}
}
\value{
logical vector with length (and order) matching the horizons of \code{x}
}
\description{
Flag perfectly overlapping horizons within a SoilProfileCollection
}
\details{
Horizons with \code{NA} depths can be flagged as overlapping. Consider finding these horizons with \code{checkHzDepthLogic(byhz=TRUE)} and removing or fixing them.
}
\examples{

# two overlapping horizons
z <- data.frame(
  id = 'SPC',
  top = c(0, 25, 25, 50, 75, 100, 100),
  bottom = c(25, 50, 50, 75, 100, 125, 125)
)

# init SPC
depths(z) <- id ~ top + bottom

# flag perfectly overlapping horizons
z$.overlapFlag <- flagOverlappingHz(z)

# thematic sketches
plotSPC(z, color = '.overlapFlag', hz.depths = TRUE, 
depth.axis = FALSE, cex.names = 0.85)

}
\seealso{
\code{\link[=checkHzDepthLogic]{checkHzDepthLogic()}} \code{\link[=fillHzGaps]{fillHzGaps()}}
}
\author{
D.E. Beaudette, A.G. Brown
}
