% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/huePositionCircle.R
\name{huePositionCircle}
\alias{huePositionCircle}
\title{Visual Description of Munsell Hue Ordering}
\usage{
huePositionCircle(
  hues = huePosition(returnHues = TRUE),
  value = 6,
  chroma = 10,
  chip.cex = 5.5,
  label.cex = 0.66,
  seg.adj = 0.8,
  seg.col = grey(0.4),
  plot = TRUE,
  simulateCVD = NULL,
  CVDseverity = 1
)
}
\arguments{
\item{hues}{vector of Munsell hues, commonly derived from \code{huePosition()}}

\item{value}{single integer, Munsell value used to create an actual color}

\item{chroma}{single integer, Munsell chroma used to create an actual color}

\item{chip.cex}{numeric, scaling for color chips}

\item{label.cex}{numeric, scaling labels}

\item{seg.adj}{numeric, scaling for line segment cues}

\item{seg.col}{single color, color used for line segment cues}

\item{plot}{logical, generate output on the current graphics device}

\item{simulateCVD}{simulate color vision deficiencies with the colorspace package, should be the character representation of a function name, one of: 'deutan', 'protan', or 'tritan'.}

\item{CVDseverity}{numeric value between 0 (none) and 1 (total), describing the severity of the color vision deficiency}
}
\value{
an invisible \code{data.frame} of data used to create the figure
}
\description{
Munsell hues are arranged on the unit circle with "neutral" at the center.
}
\note{
The best results are obtained when setting margins to zero, and inverting foreground / background colors. For example: \code{par(mar = c(0, 0, 0, 0), fg = 'white', bg = 'black')}.
}
\examples{

# keep examples from using more than 2 cores
data.table::setDTthreads(Sys.getenv("OMP_THREAD_LIMIT", unset = 2))


# better graphics defaults
op <- par(
mar = c(0, 0, 0, 0), 
fg = 'white', 
bg = 'black', 
xpd = NA
)

# full set of hues, as generated by huePosition(returnHues = TRUE)
huePositionCircle()

# just a few hues
huePositionCircle(hues = c('5R', '5Y', '5G', '5B', '5P'))

# adjust Munsell value and chroma
huePositionCircle(value = 3, chroma = 6)

# reset graphics state
par(op)

}
\references{
Munsell book of color. 1976. Macbeth, a Division of Kollmorgen Corp., Baltimore, MD.
}
