% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-requests.R
\name{fetch_layer_metadata}
\alias{fetch_layer_metadata}
\title{Retrieve metadata}
\usage{
fetch_layer_metadata(url, token = NULL, call = rlang::caller_env())
}
\arguments{
\item{url}{the url of the item.}

\item{token}{an \code{httr2_token} from one of the provided \code{auth_} functions}

\item{call}{default \code{\link[rlang:stack]{rlang::caller_env()}}. The calling environment passed to \code{detect_errors()}.}
}
\value{
returns a list object
}
\description{
Utility functions for feature service metadata.
}
\details{
\itemize{
\item \code{fetch_layer_metadata()} given a request, fetches the metadata by setting
the query parameter \code{f=json}
}
}
\examples{
# url is broken into parts to fit within 100 characters to avoid CRAN notes
url_parts <- c(
  "https://services.arcgis.com/P3ePLMYs2RVChkJx/ArcGIS/rest/services",
  "/USA_Counties_Generalized_Boundaries/FeatureServer/0"
)

furl <- paste0(url_parts, collapse = "")
meta <- fetch_layer_metadata(furl)
head(names(meta))
}
