% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/twocolorpal.R
\name{twocolorpal}
\alias{twocolorpal}
\title{Create vector of colors from blue to white to red}
\usage{
twocolorpal(colors = c("slateblue", "white", "violetred"), n = 256, ...)
}
\arguments{
\item{colors}{Vector of three colors}

\item{n}{Number of colors in output.}

\item{...}{Passed to \code{\link[grDevices:colorRamp]{grDevices::colorRampPalette()}}.}
}
\value{
Vector of colors, from blue to white to red
}
\description{
Create a two-color palette from one color to another through some third color
}
\examples{
x <- matrix(rnorm(100, 0.5), ncol=10)
mxabs <- max(abs(x))
image(x, col=twocolorpal(), zlim=c(-mxabs, mxabs))

}
\seealso{
\code{\link[=revgray]{revgray()}}
}
\keyword{color}
