% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/custom_tidiers.R
\name{tidy_svy_vglm}
\alias{tidy_svy_vglm}
\title{Tidy a \code{svy_vglm} model}
\usage{
tidy_svy_vglm(x, conf.int = TRUE, conf.level = 0.95, ...)
}
\arguments{
\item{x}{(\code{svy_vglm})\cr
A \code{svyVGAM::svy_vglm()} model.}

\item{conf.int}{(\code{logical})\cr
Whether or not to include a confidence interval in the tidied output.}

\item{conf.level}{(\code{numeric})\cr
The confidence level to use for the confidence interval (between \code{0} ans \code{1}).}

\item{...}{Additional parameters passed to \code{parameters::model_parameters()}.}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
A tidier for models generated with \code{svyVGAM::svy_vglm()}.
Term names will be updated to be consistent with generic models. The original
term names are preserved in an \code{"original_term"} column. Depending on the
model, additional column \code{"group"}, \code{"component"} and/or \code{"y.level"} may be
added to the results.
}
\examples{
\dontshow{if (.assert_package("svyVGAM", boolean = TRUE)) withAutoprint(\{ # examplesIf}
\donttest{
  library(svyVGAM)

  mod <- svy_vglm(
    Species ~ Sepal.Length + Sepal.Width,
    family = multinomial(),
    design = survey::svydesign(~1, data = iris)
  )
  mod |> tidy_svy_vglm(exponentiate = TRUE)
}
\dontshow{\}) # examplesIf}
}
\seealso{
Other custom_tidiers: 
\code{\link{tidy_broom}()},
\code{\link{tidy_multgee}()},
\code{\link{tidy_parameters}()},
\code{\link{tidy_vgam}()},
\code{\link{tidy_with_broom_or_parameters}()},
\code{\link{tidy_zeroinfl}()}
}
\concept{custom_tidiers}
