% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{empathy_cat}
\alias{empathy_cat}
\title{Empathizing Quotient Cat Object}
\format{
An object of class \code{Cat} of length 1.
}
\source{
See \code{https://dataverse.harvard.edu/dataverse/pdsl} for the raw YouGov and/or Qualtrics data.
}
\usage{
data(empathy_cat)
}
\description{
Cat object containing item parameters for graded response model fit with responses to the 40-item Empathy Quotient personality inventory
}
\details{
Cat object containing item parameters for graded response model fit with
 13976 response profiles collected by myPersonality Project, 3050 response profiles
collected by Qualtrics in June 2018, and 1500 response profiles collected by YouGov in June 2018. 
The sample from myPersonality Project was a convenience sample, and the
respondents from YouGov were matched to a sampling frame on gender, age, race, and education.

See \code{\link{Cat-class}} for details regarding the Cat object structure.
See \code{\link{grmCat}} for details regarding the graded response model.

A normal prior was chosen with mean from the theta estimates from the YouGov sample (-0.363) and a standard deviation (1.5)
wide enough to envelope the range of estimated theta values across both samples.

Note that due to how the item parameters were estimated, large, positive values indicate "more" of the latent trait.

Response options are 1=Strongly disagree; 2=Slightly disagree; 3=Slightly agree; 4=Strongly agree

The wording of the question items:

\describe{
\item{\code{q1}}{ I can easily tell if someone else wants to enter a conversation.}	 							
\item{\code{q4}}{ I find it difficult to explain to others things that I understand easily, when they don't understand it first time.}				
\item{\code{q6}}{ I really enjoy caring for other people.}
\item{\code{q8}}{ I find it hard to know what to do in a social situation.}				
\item{\code{q10}}{ People often tell me that I went too far in driving my point home in a discussion.}		
\item{\code{q11}}{ It doesn't bother me too much if I am late meeting a friend.}				
\item{\code{q12}}{ Friendships and relationships are just too difficult, so I tend not to bother with them.}	
\item{\code{q14}}{ I often find it difficult to judge if something is rude or polite.} 				
\item{\code{q15}}{ In a conversation, I tend to focus on my own thoughts rather than on what my listener might be thinking.}			
\item{\code{q18}}{ When I was a child, I enjoyed cutting up worms to see what would happen.}
\item{\code{q19}}{ I can pick up quickly if someone says one thing but means another.}				
\item{\code{q21}}{ It is hard for me to see why some things upset people so much.}				
\item{\code{q22}}{ I find it easy to put myself in somebody else's shoes.}				
\item{\code{q25}}{ I am good at predicting how someone will feel.}		
\item{\code{q26}}{ I am quick to spot when someone in a group is feeling awkward or uncomfortable.}				
\item{\code{q27}}{ If I say something that someone else is offended by, I think that that's their problem, not mine.}				
\item{\code{q28}}{ If anyone asked me if I liked their haircut, I would reply truthfully, even if I didn't like it.}				
\item{\code{q29}}{ I can't always see why someone should have felt offended by a remark.}				
\item{\code{q32}}{ Seeing people cry doesn't really upset me.}				
\item{\code{q34}}{ I am very blunt, which some people take to be rudeness, even though this is unintentional.}				
\item{\code{q35}}{ I don't tend to find social situations confusing.}				
\item{\code{q36}}{ Other people tell me I am good at understanding how they are feeling and what they are thinking.}				
\item{\code{q37}}{ When I talk to people, I tend to talk about their experiences rather than my own.}				
\item{\code{q38}}{ It upsets me to see an animal in pain.}				
\item{\code{q39}}{ I am able to make decisions without being influenced by people's feelings.}				
\item{\code{q41}}{ I can easily tell if someone else is interested or bored with what I am saying.}				
\item{\code{q42}}{ I get upset if I see people suffering on news programs.}				
\item{\code{q43}}{ Friends usually talk to me about their problems as they say that I am very understanding.}				
\item{\code{q44}}{ I can sense if I am intruding, even if the other person doesn't tell me.}				
\item{\code{q46}}{ People sometimes tell me that I have gone too far with teasing.}				
\item{\code{q48}}{ Other people often say that I am insensitive, though I don't always see why.}				
\item{\code{q49}}{ If I see a stranger in a group, I think that it is up to them to make an effort to join in.}				
\item{\code{q50}}{ I usually stay emotionally detached when watching a film.}				
\item{\code{q52}}{ I can tune into how someone else feels rapidly and intuitively.}				
\item{\code{q54}}{ I can easily work out what another person might want to talk about.}				
\item{\code{q55}}{ I can tell if someone is masking their true emotion.}				
\item{\code{q57}}{ I don't consciously work out the rules of social situations.}				
\item{\code{q58}}{ I am good at predicting what someone will do.}				
\item{\code{q59}}{ I tend to get emotionally involved with a friend's problems.}				
\item{\code{q60}}{ I can usually appreciate the other person's viewpoint, even if I don't agree with it.}
}
}
\references{
Baron-Cohen, Simon, and Sally Wheelwright. "The empathy quotient: an investigation of adults
 with Asperger syndrome or high functioning autism, and normal sex differences." Journal of autism
  and developmental disorders 34, no. 2 (2004): 163-175.
  
Stillwell, David, and Michal Kosinski. 2007. "myPersonality Project."
\url{https://sites.google.com/michalkosinski.com/mypersonality}
}
\seealso{
\code{\link{Cat-class}}, \code{\link{grmCat}}
}
\keyword{datasets}
