% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chronochrt_arrange_regions.R
\name{arrange_regions}
\alias{arrange_regions}
\title{Arranging the regions (sections) of a chronological chart}
\usage{
arrange_regions(data, order)
}
\arguments{
\item{data}{A data set with a column named "region".}

\item{order}{A character vector with the desired order of the region/section
titles. Each title must be given only once.}
}
\value{
A tibble with data ready-to-use for plotting with
  \code{\link{plot_chronochrt}}.
}
\description{
This function ensures that the regions/sections of a chronological chart and
of the accompanying labels are arranged in the desired order, not necessarily
in an alphabetical one (the default plotting order).
}
\examples{
# Create example data set

chrons <- add_chron(region = c("A", "B"),
                    name = c("a", "a"),
                    start = -100,
                    end = c(200, 150),
                    level = c(1, 1),
                    add = FALSE,
                    new_table = TRUE)

# Arrange regions

chrons <- arrange_regions(data = chrons, order = c("B", "A"))

}
