% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/send_to_dai.R
\name{dai_sync}
\alias{dai_sync}
\title{OCR document synchronously}
\usage{
dai_sync(
  file,
  proj_id = get_project_id(),
  proc_id = Sys.getenv("DAI_PROCESSOR_ID"),
  proc_v = NA,
  skip_rev = "true",
  loc = "eu",
  token = dai_token()
)
}
\arguments{
\item{file}{path to a single-page pdf or image file}

\item{proj_id}{a GCS project id.}

\item{proc_id}{a Document AI processor id.}

\item{proc_v}{one of 1) a processor version name, 2) "stable" for the
latest processor from the stable channel, or 3) "rc" for the latest
processor from the release candidate channel.}

\item{skip_rev}{whether to skip human review; "true" or "false".}

\item{loc}{a two-letter region code; "eu" or "us".}

\item{token}{an authentication token generated by \code{dai_auth()} or
another auth function.}
}
\value{
a HTTP response object.
}
\description{
Sends a single document to the Google Cloud Services (GCS)
Document AI v1 API for synchronous (immediate) processing. Returns a
HTTP response object containing the OCRed text and additional data.
}
\details{
Requires a GCS access token and some configuration of the
.Renviron file; see package vignettes for details.Input files can be in
either .pdf, .bmp, .gif, .jpeg, .jpg, .png, or .tiff format. PDF files
can be up to five pages long. Extract the text from the response object with
\code{text_from_dai_response()}. Inspect the entire response object with
\code{httr::content()}.
}
\examples{
\dontrun{
response <- dai_sync("doc_page.pdf")

response <- dai_sync("doc_page.pdf",
  proc_v = "pretrained-ocr-v1.1-2022-09-12"
)
}
}
