% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trans_sample_strat.R
\name{sample_stratified}
\alias{sample_stratified}
\title{Stratified sampling}
\usage{
sample_stratified(attribute)
}
\arguments{
\item{attribute}{attribute target to model building}
}
\value{
returns an object of class \code{sample_stratified}
}
\description{
Train/test split and k‑fold partitioning that preserve the target class proportions (strata).
}
\examples{
#using stratified sampling
sample <- sample_stratified("Species")
tt <- train_test(sample, iris)

# distribution of train
table(tt$train$Species)

# preparing dataset into four folds
folds <- k_fold(sample, iris, 4)

# distribution of folds
tbl <- NULL
for (f in folds) {
 tbl <- rbind(tbl, table(f$Species))
}
head(tbl)
}
