% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gl.read.fasta.r
\name{gl.read.fasta}
\alias{gl.read.fasta}
\title{Reads FASTA files and converts them to genlight object}
\usage{
gl.read.fasta(fasta.files, parallel = FALSE, n.cores = NULL, verbose = NULL)
}
\arguments{
\item{fasta.files}{Fasta files to read [required].}

\item{parallel}{A logical indicating whether multiple cores -if available-
should be used for the computations (TRUE), or not (FALSE); requires the
 package parallel to be installed [default FALSE].}

\item{n.cores}{If parallel is TRUE, the number of cores to be used in the
computations; if NULL, then the maximum number of cores available on the
 computer is used [default NULL].}

\item{verbose}{Verbosity: 0, silent or fatal errors; 1, begin and end; 2,
progress log; 3, progress and results summary; 5, full report
[default 2, unless specified using gl.set.verbosity].}
}
\value{
A genlight object.
}
\description{
The following IUPAC Ambiguity Codes are taken as heterozygotes:
\itemize{
 \item M is heterozygote for	AC and CA	
 \item R is heterozygote	for AG and GA	
 \item W is heterozygote	for AT and TA	
 \item S is heterozygote	for CG and GC
 \item Y is heterozygote	for CT and TC
 \item K is heterozygote	for GT and TG
 }
The following IUPAC Ambiguity Codes are taken as missing data:
\itemize{
 \item V
 \item H 
 \item D 
 \item B
 \item N 
 }
 The function can deal with missing data in individuals, e.g. when FASTA 
 files have different number of individuals due to missing data.
 The allele with the highest frequency is taken as the reference allele.
 SNPs with more than two alleles are skipped.
}
\details{
Ambiguity characters are often used to code heterozygotes. However, using
 heterozygotes as ambiguity characters may bias many estimates. See more
  information in the link below:
\url{https://evodify.com/heterozygotes-ambiguity-characters/}
}
\seealso{
Other io: 
\code{\link{gl.load}()},
\code{\link{gl.read.csv}()},
\code{\link{gl.read.dart}()},
\code{\link{gl.read.silicodart}()},
\code{\link{gl.save}()},
\code{\link{gl.write.csv}()},
\code{\link{utils.read.dart}()}
}
\author{
Custodian: Luis Mijangos -- Post to
\url{https://groups.google.com/d/forum/dartr}
}
\concept{io}
