% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/descstat.r
\name{descstat}
\alias{descstat}
\title{Creates a descriptive statistics table for continuous
variables.}
\usage{
descstat(
  data = data,
  decnum = 3,
  eng = TRUE,
  full = FALSE,
  reduced = FALSE,
  all.outputs = FALSE,
  landscape = FALSE,
  short.names = FALSE,
  ...
)
}
\arguments{
\item{data}{a dataframe containing numeric variables as columns.}

\item{decnum}{the number of decimals to be used in the output. The
default is set to 3.}

\item{eng}{logical; if \code{TRUE} (by default), the language of the
statistics will be in English; if "FALSE" will be in Spanish.
descriptive statistics. The default is to \code{FALSE}.}

\item{full}{logical; if \code{TRUE}, the output includes some extra
descriptive statistics. The default is to \code{FALSE}.}

\item{reduced}{logical; if \code{TRUE}, the output includes the same
descriptive statistics as using the summary() basis R function.}

\item{all.outputs}{logical; if \code{TRUE}, the returns several elements
as results of the function, which can be of importance for
further analyses later on. The default is to \code{FALSE}.}

\item{landscape}{logical; the default is set to \code{FALSE}, thus
the output table will have the statistics as rows, and in each
column the variables. Otherwise, if \code{TRUE} the variables will
be the rows, and each statistics the columns. Therefore this last
option is only advisable when \code{full=FALSE}.}

\item{short.names}{logical; if \code{TRUE}, the names of the
computed statistics are in lower cases and are short compared to
the more formal ones. For instance, "sd" is used instead of
"Std. Dev.", furthermore, no space is used among letters.
The default is to \code{FALSE}.}

\item{...}{aditional options for basic stats functions.}
}
\value{
This function wraps descriptive statistics into a
summarize table having the following statistics: sample size,
minimum, maximum, mean, median, SD, and coefficient of variation.
If the \code{full} option is set to \code{TRUE}, the following
statistics will be added to the table: 25th and 75th
percentiles, the interquartile range, skewness, and kurtosis.
}
\description{
Function to create a descriptive statistics table for continuous
variables from a dataframe.
}
\details{
The resulting table offers the main central and dispersion
statistics.
}
\examples{
df <- datana::idahohd
head(df)
df.h<-df[,c("dbh","toth")]
## using the function
descstat(data=df.h)
descstat(data=df.h,decnum=1,eng=FALSE)
descstat(df.h,2)
descstat(df.h,2,full=TRUE)
descstat(df.h,2,reduced=TRUE)
descstat(df.h,2,reduced=TRUE,eng=FALSE)
descstat(data=df.h[,"dbh"],decnum=1,eng=FALSE,landscape = FALSE)
}
\references{
\itemize{
\item Salas-Eljatib C. 2021. Análisis de datos con el programa estadístico R:
una introducción aplicada. Ediciones Universidad Mayor. Santiago, Chile.
\url{https://eljatib.com}
}
}
\author{
Christian Salas-Eljatib and Tomas Cayul.
}
