% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AdvancedTuning.R
\name{RunInteractiveTuning}
\alias{RunInteractiveTuning}
\title{Run an interactive model tuning session.}
\usage{
RunInteractiveTuning(model)
}
\arguments{
\item{model}{dataRobotModel. A DataRobot model object to get tuning parameters for.}
}
\value{
A job ID that can be used to get the tuned model.
}
\description{
The advanced tuning feature allows you to manually set model parameters and override the
DataRobot default selections. It is generally available for Eureqa models. To use this
feature with other model types, contact your CFDS for more information.
}
\details{
This function runs an interactive session to iterate you through individual arguments
for each tunable hyperparameter, presenting you with the defaults and other available
information. You can set each parameter one at a time, skipping ones you don't intend to
set. At the end, it will return a job ID that can be used to get the tuned model.

Note that sometimes you may see the exact same parameter more than once. These are for
different parts of the blueprint that use the same parameter (e.g., one hot encoding for
text and then one hot encoding for numeric). They are listed in the order they are found
in the blueprint but unfortunately more user-facing information cannot be provided.
}
\examples{
\dontrun{
  projectId <- "59a5af20c80891534e3c2bde"
  modelId <- "5996f820af07fc605e81ead4"
  myXGBModel <- GetModel(projectId, modelId)
  tuningJob <- RunInteractiveTuning(myXGBModel)
  tunedModel <- GetModelFromJobId(projectId, tuningJob)
}
}
