% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/honest_did.R
\name{honest_did_did2s}
\alias{honest_did_did2s}
\title{honest_did_did2s}
\usage{
honest_did_did2s(
  es,
  e = 0,
  type = c("smoothness", "relative_magnitude"),
  method = NULL,
  bound = "deviation from parallel trends",
  Mvec = NULL,
  Mbarvec = NULL,
  monotonicityDirection = NULL,
  biasDirection = NULL,
  alpha = 0.05,
  parallel = FALSE,
  gridPoints = 10^3,
  grid.ub = NA,
  grid.lb = NA,
  ...
)
}
\arguments{
\item{es}{an object of class \code{honestdid_obj_did2s} from the function \code{get_honestdid_obj_did2s}}

\item{e}{event time to compute the sensitivity analysis for.
The default value is \code{e=0} corresponding to the "on impact"
effect of participating in the treatment.}

\item{type}{Options are "smoothness" (which conducts a
sensitivity analysis allowing for violations of linear trends
in pre-treatment periods) or "relative_magnitude" (which
conducts a sensitivity analysis based on the relative magnitudes
of deviations from parallel trends in pre-treatment periods).}

\item{method}{
  String that specifies the choice of method for constructing robust confidence intervals. This must be one of "FLCI", "Conditional", "C-F" (conditional FLCI hybrid), or "C-LF" (conditional least-favorable hybrid). Default equals NULL and the function automatically sets method based on the recommendations in Rambachan & Roth (2021) depending on the choice of Delta. If Delta = DeltaSD, default selects the FLCI. If Delta = DeltaSDB or DeltaSDM, default delects the conditional FLCI hybrid.
  }

\item{bound}{
  String that specifies the base choice of Delta (to which additional sign and shape restrictions will be incorporated if specified by the user). This must be either "deviation from parallel trends" or "deviation from linear trend". If bound equals "deviation from parallel trends", then the function will select \eqn{\Delta^{RM}(Mbar)} as the base choice of \eqn{\Delta}. If bound equals "deviation from linear trends", then the function will select \eqn{\Delta^{SDRM}} as the base choice of \eqn{\Delta}. By default, this is set to "deviation from parallel trends". See Section 2.3.1 and 2.3.2 of Rambachan & Roth (2021) for a discussion of these choices of \eqn{\Delta}.
  }

\item{Mvec}{
  Vector of M values for which the user wishes to construct robust confidence intervals. If NULL, the function constructs a grid of length 10 that starts at M = 0 and ends at M equal to the upper bound constructed from the pre-periods using the function DeltaSD_upperBound_Mpre if number of pre-periods > 1 or the standard deviation of the first pre-period coefficient if number of pre-periods = 1. Default equals null.
  }

\item{Mbarvec}{
  Vector of Mbar values for which the user wishes to construct robust confidence intervals. If NULL, the function constructs a grid of length 10 that starts at Mbar = 0 and ends at Mbar = 2. Default equals null.
  }

\item{monotonicityDirection}{
  This must be specified if the user wishes to add an additional monotonicity restriction to \eqn{\Delta^{SD}(M)}. If "increasing", underlying trend specified to be increasing, \eqn{\delta_t \ge \delta_{t-1}}. If "decreasing", underlying trend specified to be decreasing \eqn{\delta_t \le \delta_{t-1}}. Default equals NULL
  }

\item{biasDirection}{
  This must be specified if the user wishes to add an additional bias restriction to \eqn{\Delta^{SD}(M)}. If "positive", bias is restricted to be positive, \eqn{\delta \ge 0}. If "negative", bias is restricted to be negative, \eqn{\delta \le 0}. Default equals NULL.
  }

\item{alpha}{
  Desired size of the robust confidence sets. Default equals 0.05 (corresponding to 95\% confidence interval)
  }

\item{parallel}{
  Logical to indicate whether the user would like to construct the robust confidence intervals in parallel. This uses the Foreach package and doParallel package. Default equals FALSE.
  }

\item{gridPoints}{
  Number of grid points used for the underlying test inversion. Default equals 1000. User may wish to change the number of grid points for computational reasons.
  }

\item{grid.ub}{
  Upper bound of grid used for underlying test inversion. Default sets grid.ub to be equal to twenty times the standard deviation of the estimated target parameter, l_vec * betahat. User may wish to change the upper bound of the grid to suit their application.
  }

\item{grid.lb}{
  Lower bound of grid used for underlying test inversion. Default sets grid.lb to be equal to negative twenty times the standard deviation of the estimated target parameter, l_vec * betahat. User may wish to change the lower bound of the grid to suit their application.
  }

\item{...}{Ignored.}
}
\description{
a function to compute a sensitivity analysis using the
approach of Rambachan and Roth (2021) when the event study is
estimated using the \code{did2s} package. Note that you should first
use the helper function \code{get_honestdid_obj_did2s} to create the
object, \code{obj}, that you will then pass into this function with
\code{honest_did(obj)}
}
