#' Matched lead crime dataset
#'
#' A matched, trimmed dataset of early life lead exposure and
#' juvenile delinquency from a public dataset. There are 2007 matched sets.
#'
#' @format ## `lead_crime`
#' A data frame with 4,134 rows and 17 columns:
#' \describe{
#'   \item{log_lead}{The log of lead exposure level measured in micrograms per deciliter.}
#'   \item{serious}{Whether the juvenile comitted a serious offense.}
#'   \item{complain}{Whether the juvenile comitted an offense worthy of complaint.}
#'   \item{matched_sets}{Matched set membership.}
#'   ...
#' }
#' @source <https://scholarworks.iu.edu/dspace/handle/2022/25638>
"lead_crime"


#' Matched lead bone mineral density dataset
#'
#' A matched, trimmed dataset of lead exposure and lumbar bone mineral density.
#' The data comes from NHANES 2011-18. There are 711 matched sets.
#'
#' @format ## `lead_bmd`
#' A data frame with 1,436 rows and 23 columns:
#' \describe{
#'   \item{log_lead}{The log of lead exposure level measured in micrograms per deciliter.}
#'   \item{lumbar_spine_bmd}{Bone mineral density in the lumbar spine in g/cm^2}
#'   \item{matched_sets}{Matched set membership.}
#'   ...
#' }
#' @source <https://wwwn.cdc.gov/nchs/nhanes/default.aspx>
"lead_bmd"
