% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/survival_utils.R
\name{fastml_normalize_survival_status}
\alias{fastml_normalize_survival_status}
\title{Internal helpers for survival-specific preprocessing}
\usage{
fastml_normalize_survival_status(status_vec, reference_length = NULL)
}
\arguments{
\item{status_vec}{A vector containing survival status information. May be
numeric, logical, factor, or character.}

\item{reference_length}{Optional integer specifying the desired length of the
returned vector. When `status_vec` is `NULL`, this value controls the
length of the output (defaulting to 0 when not supplied).}
}
\value{
A list with two elements: `status`, the recoded numeric vector, and
  `recoded`, a logical flag indicating whether a non-standard encoding was
  detected.
}
\description{
These utilities standardize survival status indicators so that downstream
metrics always receive the conventional coding (0 = censored, 1 = event).
The functions are intentionally unexported and are used across multiple
internal modules.
Normalize survival status coding to 0/1 representation
}
\details{
This helper attempts to coerce a status vector into a numeric format where
0 represents censoring and 1 represents the event indicator. It accepts a
variety of common encodings such as 1/2, logical values, factors, or
character labels. When the supplied values deviate from the canonical
coding, the function records that a recode was performed so callers can
communicate this to the user (once).
}
