% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.fastml.R
\name{plot.fastml}
\alias{plot.fastml}
\title{Plot Methods for \code{fastml} Objects}
\usage{
\method{plot}{fastml}(
  x,
  algorithm = "best",
  type = c("all", "bar", "roc", "calibration", "residual"),
  ...
)
}
\arguments{
\item{x}{A \code{fastml} object (output of \code{\link{fastml}()}).}

\item{algorithm}{Character vector specifying which algorithm(s) to include when
generating certain plots (e.g., ROC curves). Defaults to \code{"best"}.}

\item{type}{Character vector indicating which plot(s) to produce. Options are:
\describe{
  \item{\code{"bar"}}{Bar plot of performance metrics across all models/engines.}
  \item{\code{"roc"}}{ROC curve(s) for binary classification models.}
  \item{\code{"calibration"}}{Calibration plot for the best model(s).}
  \item{\code{"residual"}}{Residual diagnostics for the best model.}
  \item{\code{"all"}}{Produce all available plots.}
}}

\item{...}{Additional arguments (currently unused).}
}
\description{
\code{plot.fastml} produces visual diagnostics for a trained \code{fastml} object.
}
\details{
When \code{type = "all"}, \code{plot.fastml} will produce a bar plot of metrics,
ROC curves (classification), calibration plot, and residual diagnostics (regression).
If you specify a subset of types, only those will be drawn.
}
\examples{
\donttest{
  ## Create a binary classification dataset from iris
  data(iris)
  iris <- iris[iris$Species != "setosa",]
  iris$Species <- factor(iris$Species)

  ## Fit fastml model on binary classification task
  model <- fastml(data = iris, label = "Species", algorithms = c("rand_forest", "svm_rbf"))

  ## 1. Plot all available diagnostics
  plot(model, type = "all")

  ## 2. Bar plot of performance metrics
  plot(model, type = "bar")

  ## 3. ROC curves (only for classification models)
  plot(model, type = "roc")

  ## 4. Calibration plot (requires 'probably' package)
  plot(model, type = "calibration")

  ## 5. ROC curves for specific algorithm(s) only
  plot(model, type = "roc", algorithm = "rand_forest")

  ## 6. Residual diagnostics (only available for regression tasks)
  model <- fastml(data = mtcars, label = "mpg", algorithms = c("linear_reg", "xgboost"))
  plot(model, type = "residual")
}

}
