% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multiple_entries.R
\name{fhir_melt_all}
\alias{fhir_melt_all}
\title{Melt all columns with multiple entries}
\usage{
fhir_melt_all(indexed_data_frame, brackets, sep, column_name_separator = ".")
}
\arguments{
\item{indexed_data_frame}{A data.frame/data.table with indexed multiple entries.}

\item{brackets}{A character vector of length two, defining the brackets used for the indices.}

\item{sep}{A character vector of length one defining the separator that was used when pasting together multiple entries in \code{\link[=fhir_crack]{fhir_crack()}}.}

\item{column_name_separator}{A character string that separates element levels column names. Defaults to ".", which is used when
column names were generated automatically with \code{\link[=fhir_crack]{fhir_crack()}}.}
}
\value{
A completely molten data.table.
}
\description{
This function divides all multiple entries in an indexed data frame as produced by \code{\link[=fhir_crack]{fhir_crack()}}
into separate rows.
}
\details{
The function repeatedly calls \code{\link[=fhir_melt]{fhir_melt()}} on groups of columns that belong to the same
FHIR element (e.g. \code{address.city}, \code{address.country} and \code{address.type}) until every cell contains a single value.
If there is more than one FHIR element with multiple values (e.g. multiple address elements and multiple name
elements), every possible combination of the two elements will appear in the resulting table.
Caution! This creates something like a cross product of all values and can multiply the number of rows from the original
table considerably.
}
\examples{
#unserialize example
bundles <- fhir_unserialize(bundles = example_bundles1)

#crack fhir resources
table_desc <- fhir_table_description(
    resource = "Patient",
    brackets = c("[", "]"),
    sep = " "
)

df <- fhir_crack(bundles = bundles, design = table_desc)

#original data frame
df

#melt all multiple entries
fhir_melt_all(
     indexed_data_frame = df,
     brackets           = c("[", "]"),
     sep = " "
 )
}
