% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/miscellaneous.R
\docType{methods}
\name{fhir_rm_tag}
\alias{fhir_rm_tag}
\alias{fhir_rm_tag,character-method}
\alias{fhir_rm_tag,fhir_bundle_xml-method}
\alias{fhir_rm_tag,fhir_bundle_list-method}
\title{Remove a certain xml tag}
\usage{
fhir_rm_tag(x, tag)

\S4method{fhir_rm_tag}{character}(x, tag)

\S4method{fhir_rm_tag}{fhir_bundle_xml}(x, tag)

\S4method{fhir_rm_tag}{fhir_bundle_list}(x, tag)
}
\arguments{
\item{x}{A \linkS4class{fhir_bundle_xml} or \linkS4class{fhir_bundle_list} object or a character vector
containing xml objects.}

\item{tag}{A character vector of length 1 containing the tag that should be removed, e.g. \code{"div"}.}
}
\value{
An object of the same class as \code{x} where all tags matching the \code{tag} argument are removed.
}
\description{
Removes a given xml tag from xml objects represented in a \linkS4class{fhir_bundle_xml}, \linkS4class{fhir_bundle_list}
or character vector.
}
\details{
In the example \verb{Hello<div>Please<p>Remove Me</p></div>World!} one could for example remove the
tag \code{p}, resulting in \verb{Hello<div>Please</div>World!}or remove the \code{div} tag resulting in
\verb{Hello World!}.
}
\examples{

#Example 1: Remove tag from xmls in a character vector
string <- c("Hello<div>Please<p>Remove Me</p></div> World!",
            "A<div><div><p>B</p></div>C</div>D")

fhir_rm_tag(x = string, tag = "p")




#Example 2: Remove div tags in a single fhir bundle
bundle <- fhir_unserialize(patient_bundles)[[1]]

#example bundle contains html parts in div tags:
cat(toString(bundle))

#remove html parts
bundle_cleaned <- fhir_rm_tag(x = bundle, tag = "div")

#have a look at the result
cat(toString(bundle_cleaned))





#Example 3: Remove div tags in a list of fhir bundles
bundle_list <- fhir_unserialize(patient_bundles)


#remove html parts
bundle_list_cleaned <- fhir_rm_tag(x = bundle_list, tag = "div")

#check out how much the size of the bundle list is reduced by removing html
size_with_html <- sum(sapply(bundle_list, function(x)object.size(toString(x))))
size_without_html <- sum(sapply(bundle_list_cleaned, function(x)object.size(toString(x))))

size_without_html/size_with_html

}
\seealso{
\code{\link[=fhir_rm_div]{fhir_rm_div()}}
}
