% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.frailtyIllnessDeath.R
\name{summary.frailtyIllnessDeath}
\alias{summary.frailtyIllnessDeath}
\alias{print.summary.frailtyIllnessDeath}
\title{Summary of parameter estimates of a Weibull Illness-Death model with (or without) shared frailty between transitions.}
\usage{
\method{summary}{frailtyIllnessDeath}(object, level = 0.95, len = 6, d = 2,
                                 lab="hr",...)
}
\arguments{
\item{object}{output from a call to frailtyIllnessDeath.}

\item{level}{significance level of confidence interval. Default is 95\%.}

\item{len}{the total field width. Default is 6.}

\item{d}{the desired number of digits after the decimal point. Default of 6
digits is used.}

\item{lab}{label of printed results.}

\item{...}{other unused arguments.}
}
\value{
Prints HR and its confidence intervals. Confidence level is allowed
  (level argument).
}
\description{
This function returns hazard rations (HR) and its confidence intervals
}
\examples{

  \donttest{



    ###--- Semi-Markovian Weibull Illness-Death model with left truncation ---###

    data(Paq810)

    ModIllnessDeath_LeftTrunc <- frailtyIllnessDeath(formula = Surv(e,r,dementia) ~ gender+certif,
    formula.terminalEvent = Surv(t,death) ~ gender+certif  ,
    data=Paq810, print.info = FALSE, maxit=100)

    #-- confidence interval at 95\\% level (default)

    summary(ModIllnessDeath_LeftTrunc)

    #-- confidence interval at 99\\% level

    summary(ModIllnessDeath_LeftTrunc,level=0.99)

  }
}
\seealso{
\code{\link{frailtyIllnessDeath}}
}
\keyword{methods}
