% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidy_format_translators.R
\name{tidy-format-translators}
\alias{tidy-format-translators}
\alias{to_broom_names}
\alias{from_broom_names}
\alias{to_ggmcmc_names}
\alias{from_ggmcmc_names}
\title{Translate between different tidy data frame formats for draws from distributions}
\usage{
to_broom_names(data)

from_broom_names(data)

to_ggmcmc_names(data)

from_ggmcmc_names(data)
}
\arguments{
\item{data}{<\link{data.frame}> A data frame to translate.}
}
\value{
A data frame with (possibly) new names in some columns, according to the
translation scheme described in \strong{Details}.
}
\description{
These functions translate \pkg{ggdist}/\pkg{tidybayes}-style data frames to/from different data frame
formats (each format using a different naming scheme for its columns).
}
\details{
Function prefixed with \code{to_} translate from the \pkg{ggdist}/\pkg{tidybayes} format to another format, functions
prefixed with \code{from_} translate from that format back to the \pkg{ggdist}/\pkg{tidybayes} format. Formats include:

\code{\link[=to_broom_names]{to_broom_names()}} / \code{\link[=from_broom_names]{from_broom_names()}}:

\itemize{
\item \code{.variable} <-> \code{term}
\item \code{.value} <-> \code{estimate}
\item \code{.prediction} <-> \code{.fitted}
\item \code{.lower} <-> \code{conf.low}
\item \code{.upper} <-> \code{conf.high}
}

\code{\link[=to_ggmcmc_names]{to_ggmcmc_names()}} / \code{\link[=from_ggmcmc_names]{from_ggmcmc_names()}}:

\itemize{
\item \code{.chain} <-> \code{Chain}
\item \code{.iteration} <-> \code{Iteration}
\item \code{.variable} <-> \code{Parameter}
\item \code{.value} <-> \code{value}
}
}
\examples{

library(dplyr)

data(RankCorr_u_tau, package = "ggdist")

df = RankCorr_u_tau \%>\%
  dplyr::rename(.variable = i, .value = u_tau) \%>\%
  group_by(.variable) \%>\%
  median_qi(.value)

df

df \%>\%
  to_broom_names()

}
\author{
Matthew Kay
}
\keyword{manip}
