% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reexport.R
\name{label_date}
\alias{label_date}
\alias{label_date_short}
\title{Date labeller}
\usage{
label_date(format = "\%Y-\%m-\%d", tz = "UTC", locale = NULL)

label_date_short(
  format = c("\%Y", "\%b", "\%d", "\%H:\%M"),
  sep = "\\n",
  leading = "0",
  tz = "UTC",
  locale = NULL
)
}
\arguments{
\item{format}{For \code{label_date()} and \code{label_time()} a date/time format
string using standard POSIX specification.  See \code{\link[=strptime]{strptime()}} for details.

For \code{label_date_short()} a character vector of length 4 giving the format
components to use for year, month, day, and hour respectively.}

\item{tz}{a time zone name, see \code{\link[=timezones]{timezones()}}. Defaults
to UTC}

\item{locale}{Locale to use when for day and month names. The default
uses the current locale. Setting this argument requires stringi, and you
can see a complete list of supported locales with
\code{\link[stringi:stri_locale_list]{stringi::stri_locale_list()}}.}

\item{sep}{Separator to use when combining date formats into a single string.}

\item{leading}{A string to replace leading zeroes with. Can be \code{""} to
disable leading characters or \code{"\u2007"} for figure-spaces.}
}
\value{
A character vector of formatted dates.
}
\description{
Re-export from the scales package.
\itemize{
\item Can be used to overwrite the default locale of date labels.
\item \code{label_date_short()} only labels part of the dates, when they change,
i.e. year is only labelled when the year changes.
\item See \code{\link[scales:label_date]{scales::label_date()}} and \code{\link[scales:label_date]{scales::label_date_short()}} for more details.
}
}
\examples{
library(tidyr)
library(outbreaks)
library(ggplot2)

# Change locale of date labels to Italian
sars_canada_2003 |> # SARS dataset from outbreaks
  pivot_longer(starts_with("cases"), names_prefix = "cases_", names_to = "origin") |>
  ggplot(aes(x = date, weight = value, fill = origin)) +
  geom_epicurve(date_resolution = "week") +
  scale_x_date(labels = label_date("\%B \%Y", locale = "it"), date_breaks = "1 month") +
  scale_y_cases_5er() +
  theme_classic()

# label_date_short()
sars_canada_2003 |> # SARS dataset from outbreaks
  pivot_longer(starts_with("cases"), names_prefix = "cases_", names_to = "origin") |>
  ggplot(aes(x = date, weight = value, fill = origin)) +
  geom_epicurve(date_resolution = "week") +
  scale_x_date(labels = label_date_short(), date_breaks = "1 week") +
  scale_y_cases_5er() +
  theme_classic()

}
