% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glm_rmap.R
\name{glm.rmap}
\alias{glm.rmap}
\title{Posterior of robust meta-analytic predictive prior (RMAP)}
\usage{
glm.rmap(
  formula,
  family,
  data.list,
  offset.list = NULL,
  w = 0.1,
  meta.mean.mean = NULL,
  meta.mean.sd = NULL,
  meta.sd.mean = NULL,
  meta.sd.sd = NULL,
  disp.mean = NULL,
  disp.sd = NULL,
  norm.vague.mean = NULL,
  norm.vague.sd = NULL,
  bridge.args = NULL,
  iter_warmup = 1000,
  iter_sampling = 1000,
  chains = 4,
  ...
)
}
\arguments{
\item{formula}{a two-sided formula giving the relationship between the response variable and covariates.}

\item{family}{an object of class \code{family}. See \code{\link[stats:family]{?stats::family}}.}

\item{data.list}{a list of \code{data.frame}s. The first element in the list is the current data, and the rest
are the historical data sets.}

\item{offset.list}{a list of vectors giving the offsets for each data. The length of \code{offset.list} is equal to
the length of \code{data.list}. The length of each element of \code{offset.list} is equal to the number
of rows in the corresponding element of \code{data.list}. Defaults to a list of vectors of 0s.}

\item{w}{a scalar between 0 and 1 giving how much weight to put on the historical data. Defaults to 0.1.}

\item{meta.mean.mean}{same as \code{meta.mean.mean} in \code{\link[=glm.bhm]{glm.bhm()}}. It is a scalar or a vector whose dimension is equal
to the number of regression coefficients giving the means for the normal hyperpriors on the
mean hyperparameters of regression coefficients in Bayesian hierarchical model (BHM). If a
scalar is provided, \code{meta.mean.mean} will be a vector of repeated elements of the given scalar.
Defaults to a vector of 0s.}

\item{meta.mean.sd}{same as \code{meta.mean.sd} in \code{\link[=glm.bhm]{glm.bhm()}}. It is a scalar or a vector whose dimension is equal
to the number of regression coefficients giving the sds for the normal hyperpriors on the
mean hyperparameters of regression coefficients in BHM. If a scalar is provided, same as for
\code{meta.mean.mean}. Defaults to a vector of 10s.}

\item{meta.sd.mean}{same as \code{meta.sd.mean} in \code{\link[=glm.bhm]{glm.bhm()}}. It is a scalar or a vector whose dimension is equal
to the number of regression coefficients giving the means for the half-normal hyperpriors
on the sd hyperparameters of regression coefficients in BHM. If a scalar is provided, same
as for \code{meta.mean.mean}. Defaults to a vector of 0s.}

\item{meta.sd.sd}{same as \code{meta.sd.sd} in \code{\link[=glm.bhm]{glm.bhm()}}. It is a scalar or a vector whose dimension is equal to
the number of regression coefficients giving the sds for the half-normal hyperpriors on the
sd hyperparameters of regression coefficients in BHM. If a scalar is provided, same as for
\code{meta.mean.mean}. Defaults to a vector of 1s.}

\item{disp.mean}{a scalar or a vector whose dimension is equal to the number of data sets (including the current
data) giving the location parameters for the half-normal priors on the dispersion parameters. If
a scalar is provided, same as for \code{meta.mean.mean}. Defaults to a vector of 0s.}

\item{disp.sd}{a scalar or a vector whose dimension is equal to the number of data sets (including the current
data) giving the scale parameters for the half-normal priors on the dispersion parameters. If a
scalar is provided, same as for \code{meta.mean.mean}. Defaults to a vector of 10s.}

\item{norm.vague.mean}{same as \code{beta.mean} in \code{\link[=glm.post]{glm.post()}}. It is a scalar or a vector whose dimension is equal to the
number of regression coefficients giving the means for the vague normal prior on regression
coefficients. If a scalar is provided, \code{norm.vague.mean} will be a vector of repeated elements
of the given scalar. Defaults to a vector of 0s.}

\item{norm.vague.sd}{same as \code{beta.sd} in \code{\link[=glm.post]{glm.post()}}. It is a scalar or a vector whose dimension is equal to the
number of regression coefficients giving the sds for the vague normal prior on regression
coefficients. If a scalar is provided, same as for \code{norm.vague.mean}. Defaults to a vector of 10s.}

\item{bridge.args}{a \code{list} giving arguments (other than samples, log_posterior, data, lb, ub) to pass
onto \code{\link[bridgesampling:bridge_sampler]{bridgesampling::bridge_sampler()}}.}

\item{iter_warmup}{number of warmup iterations to run per chain. Defaults to 1000. See the argument \code{iter_warmup} in
\code{sample()} method in cmdstanr package.}

\item{iter_sampling}{number of post-warmup iterations to run per chain. Defaults to 1000. See the argument \code{iter_sampling}
in \code{sample()} method in cmdstanr package.}

\item{chains}{number of Markov chains to run. Defaults to 4. See the argument \code{chains} in \code{sample()} method in
cmdstanr package.}

\item{...}{arguments passed to \code{sample()} method in cmdstanr package (e.g. seed, refresh, init).}
}
\value{
The function returns a \code{list} with the following objects

\describe{
\item{post.samples}{an object of class \code{draws_df} giving posterior samples under the robust meta-analytic predictive prior (RMAP)}

\item{post.weight.bhm}{a scalar between 0 and 1 giving the updated mixture weight for posterior density under the MAP prior}

\item{post.samples.bhm}{an object of class \code{draws_df} giving posterior samples under the Bayesian hierarchical model (BHM) (equivalently,
the MAP prior), obtained from using \code{\link[=glm.bhm]{glm.bhm()}}}

\item{post.samples.vague}{an object of class \code{draws_df} giving posterior samples under the vague/non-informative prior, obtained
from using \code{\link[=glm.post]{glm.post()}}}

\item{bs.map}{output from computing log marginal likelihood of the prior induced by the BHM (referred to as the meta-analytic predictive
(MAP) prior) via \code{\link[=glm.logml.map]{glm.logml.map()}} function}

\item{bs.vague}{output from computing log marginal likelihood of the vague prior via \code{\link[=glm.logml.post]{glm.logml.post()}} function}
}
}
\description{
Sample from the posterior distribution of a GLM using the robust meta-analytic predictive prior (RMAP)
by Schmidli et al. (2014) \url{doi:10.1111/biom.12242}.
}
\details{
The robust meta-analytic predictive prior (RMAP) is a two-part mixture prior consisting of a meta-analytic
predictive (MAP) prior (the prior induced by Bayesian hierarchical model (BHM)) and a vague (i.e.,
non-informative) prior (specifically, the normal/half-normal prior with large variances). Although Schmidli et al.
(2014) recommends to use a finite mixture of conjugate priors to approximate the BHM, it can be difficult and
time-consuming to come up with an appropriate approximation.

Instead, the approach taken by hdbayes is to use the marginal likelihood of the MAP and vague priors.
Specifically, note that the posterior distribution of a GLM under RMAP is also a two-part mixture distribution.
The updated mixture weight for posterior density under the MAP prior is
\deqn{\widetilde{w} = \frac{w Z_I(D, D_0)}{w Z_I(D, D_0) + (1-w) Z_V(D)},}
where \eqn{w} is the prior mixture weight for the MAP prior in RMAP, \eqn{Z_I(D, D_0)} is the marginal likelihood
of the MAP prior, and \eqn{Z_V(D)} is the marginal likelihood of the vague prior.
}
\examples{
\donttest{
  if (instantiate::stan_cmdstan_exists()) {
    data(actg019) ## current data
    data(actg036) ## historical data
    ## take subset for speed purposes
    actg019 = actg019[1:150, ]
    actg036 = actg036[1:100, ]
    data.list = list(actg019, actg036)
    glm.rmap(
      formula = outcome ~ scale(age) + race + treatment + scale(cd4),
      family = binomial('logit'),
      data.list = data.list,
      w = 0.1,
      chains = 1, iter_warmup = 1000, iter_sampling = 2000
    )
  }
}
}
\references{
Schmidli, H., Gsteiger, S., Roychoudhury, S., O’Hagan, A., Spiegelhalter, D., and Neuenschwander, B. (2014). Robust meta‐analytic‐predictive priors in clinical trials with historical control information. Biometrics, 70(4), 1023–1032.

Gronau, Q. F., Singmann, H., and Wagenmakers, E.-J. (2020). bridgesampling: An R package for estimating normalizing constants. Journal of Statistical Software, 92(10).
}
