% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VariableSelectionNew.R
\name{UFS}
\alias{UFS}
\title{Unsupervised Feature Selection}
\usage{
UFS(
  data = NULL,
  alpha = 0.05,
  missing = FALSE,
  pv_adj = "none",
  smooth.tol = 10^-12,
  method = "c"
)
}
\arguments{
\item{data}{A data frame. Values of type 'numeric' or 'integer' are treated as numerical, factors as ordinal categorical.}

\item{alpha}{Significance level to be used for testing, default = 0.05.}

\item{missing}{Pairwise complete by default, set to TRUE for complete deletion.}

\item{pv_adj}{Correction method for p-value, "none" by default. For options see p.adjust.}

\item{smooth.tol}{Minimum acceptable eigenvalue for the smoothing, default = 10^-12.}

\item{method}{Algorithm used. c (cell-wise) by default, r (row-wise) as the alternative.}
}
\value{
An list of elements:
   \item{rearranged.data.set}{Original data frame with with numerical features first }
   \item{selected.features}{A data frame of the selected features}
   \item{feature.indices}{The indices of the selected features from the original data frame }
   \item{original.corr.matrix}{The \eqn{p} by \eqn{p} extended correlation matrix of all the inputted features}
   \item{corr.matrix}{The \eqn{d} by \eqn{d} extended correlation matrix of the selected features}
   \item{original.p.value.matrix}{The \eqn{p} by \eqn{p} p-values matrix of all the inputted features}
   \item{p.value.matrix}{The \eqn{d} by \eqn{d} p-values matrix of the selected features}
}
\description{
Performs  unsupervised feature selection for mixed type data. Both algorithms are based on the heterogeneous correlation matrix.
}
\references{
Tortora C., Madhvani S., Punzo A.  (2025). Designing unsupervised mixed-type
feature selection techniques using the
heterogeneous correlation matrix. International Statistical Review.
https://doi.org/10.1111/insr.70016
}
\examples{
data(ESI)#Loading the data
data = ESI[,-c(1,3,4,6,9)]##removing categorical features
res = UFS(data)

### visualize selected features
colnames(res$selected.features)

}
