% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metadata_series.R
\name{get_metadata_series_table}
\alias{get_metadata_series_table}
\title{Get all the series for a given table}
\usage{
get_metadata_series_table(
  idTable = NULL,
  filter = NULL,
  det = 0,
  tip = NULL,
  lang = "ES",
  validate = TRUE,
  verbose = FALSE,
  metanames = FALSE,
  metacodes = FALSE
)
}
\arguments{
\item{idTable}{(int): id of the table. For further information about
ids click this \href{https://es-ine.github.io/ineapir/articles/identify_codes.html}{link}.}

\item{filter}{(list): list of variables and values.
\subsection{Filtering data from tables}{

When we request data from tables there is the possibility of filtering data
on the fly using metadata information about the variables and their values
that define the series. See \code{\link[=get_metadata_table_varval]{get_metadata_table_varval()}} to get all the values at once.
There are different approaches to build the filter depending on the table type.
\subsection{Case one: tempus table}{

\href{https://www.ine.es/jaxiT3/Tabla.htm?t=50902}{URL example}.
For a tempus table the filter is based on ids. The format is \code{list(id_variable1 = id_value1, id_variable2 = id_value2)}.
Besides:
\itemize{
\item A variable can take more than one value: \code{list(id_variable1 = c(id_value11, id_value12), id_variable2 = id_value2)}.
\item A variable can take a empty character "" to get all its possible values: \code{list(id_variable1 = id_value1, id_variable2 = "")}.
}
}

\subsection{Case two: px tables}{

\href{https://www.ine.es/jaxi/Tabla.htm?path=/t20/e245/p08/l0/&file=01001.px}{URL example}.
For a px table the filter is based on codes. The format is \code{list(cod_variable1 = cod_value1, cod_variable2 = cod_value2)}.
Besides:
\itemize{
\item A variable can take more than one value: \code{list(cod_variable1 = c(cod_value11, cod_value12), id_variable2 = cod_value2)}.
\item A variable can take a empty character "" to get all its possible values: \code{list(cod_variable1 = cod_value1, cod_variable2 = "")}.
}
}

\subsection{Case three: tpx table}{

\href{https://www.ine.es/jaxi/Tabla.htm?tpx=33387&L=0}{URL example}.
For a tpx table the filter is based on codes. The format is \code{list(cod_variable1 = cod_value1, cod_variable2 = cod_value2)}.
Besides:
\itemize{
\item A variable can take more than one value: \code{list(cod_variable1 = c(cod_value11, cod_value12), id_variable2 = cod_value2)}.
\item A variable can take a empty character "" to get all its possible values: \code{list(cod_variable1 = cod_value1, cod_variable2 = "")}.
}

\href{https://www.ine.es/jaxi/Tabla.htm?tpx=52056&L=0}{URL example}.
There are tpx tables that contain variable ids and value ids. In this case,
we can use the ids instead of the codes to build the filter. To do this we add
the alias \emph{~id} at the end of each id: \verb{list(id_variable1~id = id_value1~id, id_variable2~id = id_value2~id)}.
}

\subsection{Using shortcuts}{

Additionally, shortcuts can be used to filter. They simplify the filtering
approach by using standardized names for variable IDs and therefore simplify
their use. The format for a tempus table is:
\code{list(shortcut_variable1 = name1, shortcut_variable2 = name2)}. However,
for px and tpx tables the format is: \verb{list(values = c(name1, name2)}. The
\emph{values} wrapper can also be used with tempus tables.
To see a list of all available shortcuts, see \code{\link[=get_filter_shortcuts]{get_filter_shortcuts()}} function.
Let’s also remark that for better performance is recommended to use numeric ids
for tempus tables and alphanumeric codes for px and tpx tables.
}

}}

\item{det}{(int): level of detail. Valid values: 0, 1 or 2.}

\item{tip}{(string): set to 'A' for friendly output (e.g. readable dates),
set to 'M' to include metadata or set to 'AM' for both.}

\item{lang}{(string): language of the retrieved data. Set to 'ES' for Spanish or set to 'EN' for English.}

\item{validate}{(logical): validate input parameters. A FALSE value means fewer API calls.
Therefore, it is recommended to set it to FALSE when there is no doubt about the validity of the input parameters, including the filter.}

\item{verbose}{(logical): print additional information, including the URL to call the API service.}

\item{metanames}{(logical): set to TRUE to extract the name of the values that defined the table.
The names are extracted from the metadata information (it is mandatory to include 'M' in the tip parameter).
Several columns are created corresponding to the values of the different variables.}

\item{metacodes}{(logical): set to TRUE to extract the codes and ids of the values that defined the table.
The codes and ids are extracted from the metadata information (it is mandatory to include 'M' in the tip parameter).
Several columns are created corresponding to the values of the different variables.}
}
\value{
Data frame with information of the series for a given table.
}
\description{
Get all the series for a given table
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Get time series without data from table with identification code "50902"
filter <- list("3" = "83")
df <- get_metadata_series_table(idTable = 50902, validate = FALSE,
filter = filter)
head(df)

# Get metadata as well
df <- get_metadata_series_table(idTable = 50902, validate = FALSE,
filter = filter, metanames = TRUE, metacodes = TRUE, tip = "M")
head(df)
\dontshow{\}) # examplesIf}
}
