% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{bootcurve}
\alias{bootcurve}
\title{Plot Fitted Curves and Corresponding Confidence Interval using
bootstrapping method}
\usage{
bootcurve(object, nboot)
}
\arguments{
\item{object}{a fitted joint mean covariance model of class "jmcmMod", i.e.,
typically the result of jmcm().}

\item{nboot}{number of the bootstrap replications.}
}
\description{
Plot fitted curves and corresponding 95\% confidence interval
using bootstrapping method.
}
\examples{
\dontrun{
# It may take hours for large bootstrap replications
fit.mcd <- jmcm(I(sqrt(cd4)) | id | time ~ 1 | 1, data=aids,
  triple = c(8, 1, 3), cov.method = 'mcd', control = jmcmControl(trace=T))
bootcurve(fit.mcd, nboot = 1000)
}

}
