% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/miscellaneous.R
\name{replaceValues}
\alias{replaceValues}
\title{Replace Patterns with Evaluated Values}
\usage{
replaceValues(original_text, x = FALSE, capture_warnings = TRUE)
}
\arguments{
\item{original_text}{A string containing expressions within \code{{}} to be evaluated and replaced.}

\item{x}{Non-global variables to be evaluated within the function's context.}

\item{capture_warnings}{Logical. If \code{TRUE}, captures errors and warnings during evaluation and continues with replacements.
If \code{FALSE}, errors and warnings are not captured.}
}
\value{
A string with all placeholders replaced by evaluated values.
}
\description{
The \code{replaceValues()} function allows you to replace placeholders in text with variable values or evaluated expressions.
Placeholders are marked by \strong{\{\}} brackets, and the function supports capturing both global and non-global variables,
making it useful for templating and dynamic string generation in R.
}
\examples{

 # Basic example with global variables
orjTXT <- "My F value is {thisF} and  its criterion is {CrF}"
thisF <- 2.33
CrF <- 32.43
replaceValues(orjTXT)
cat(replaceValues("The summary ls: {summary(lm(mpg ~ wt + hp, data = mtcars))}\n This is example"))

 # Nested function example for non-global variables
globalY <- 10
bb <- function(x){
  y <-  x+2;
 secondFunc <- function(x){
   replaceValues("The global value of Y+3 is {globalY+3}.  The non global value is {x}",x)
  }
  secondFunc(y)
}
bb(5)


 # Nested variables example. Something like $$ in PHP
FirstVar <- "First"
SecondVar <- "Second"
FirstSecondVar <- "_____________"
orjTXT <- "First var is {FirstVar}. The combinations of var names \"FirstSecondVar\" "
orjTXT <- paste0(orjTXT,"is= {{FirstVar}{SecondVar}Var}. Where SecondVar = {SecondVar} .")
replaceValues( orjTXT)

# Using mathematical expressions
MyVar = 3
replaceValues( "First var multiplying to 12 is {MyVar*12} and its power is {MyVar^12}.")

# Using templates from external files
# file_contents <- readLines(system.file("template", templateName, package = getPackageName()))
file_contents <- readLines(system.file("template", "printkardl.txt", package = "kardl"))
data(imf_example_data)
 MyFormula<-CPI~ER+PPI+asym(ER)+deterministic(covid)+trend
 kardl_model<-kardl(imf_example_data,MyFormula,mode="quick")
output<- replaceValues(file_contents,kardl_model)
cat(output)
}
\seealso{
\code{\link[base]{eval}}, \code{\link[base]{parse}}, \code{\link[base]{gregexpr}}, \code{\link[base]{regmatches}}
}
