% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main-create_model.R
\name{priors}
\alias{priors}
\alias{normal,}
\alias{log_normal,}
\alias{gam,}
\alias{igam,}
\alias{uniform,}
\alias{student_t,}
\alias{bet}
\alias{uniform}
\alias{normal}
\alias{student_t}
\alias{gam}
\alias{igam}
\alias{log_normal}
\title{Prior definitions}
\usage{
uniform(square = FALSE)

normal(mu, sigma, square = FALSE)

student_t(nu, square = FALSE)

gam(shape, inv_scale, square = FALSE)

igam(shape, scale, square = FALSE)

log_normal(mu, sigma, square = FALSE)

bet(a, b)
}
\arguments{
\item{square}{is prior for a square-transformed parameter?}

\item{mu}{mean}

\item{sigma}{standard deviation}

\item{nu}{degrees of freedom}

\item{shape}{shape parameter (alpha)}

\item{inv_scale}{inverse scale parameter (beta)}

\item{scale}{scale parameter (beta)}

\item{a}{shape parameter}

\item{b}{shape parameter}
}
\value{
a named list
}
\description{
These use the same parametrizations as defined in the 'Stan'
documentation. See the docs for
\href{https://mc-stan.org/docs/2_24/functions-reference/gamma-distribution.html}{gamma} and
\href{https://mc-stan.org/docs/2_24/functions-reference/inverse-gamma-distribution.html}{inverse gamma} distributions.
}
\examples{
# Log-normal prior
log_normal(mu = 1, sigma = 1)

# Cauchy prior
student_t(nu = 1)

# Exponential prior with rate = 0.1
gam(shape = 1, inv_scale = 0.1)

# Create a similar priors as in LonGP (Cheng et al., 2019)
# Not recommended, because a lengthscale close to 0 is possible.
a <- log(1) - log(0.1)
log_normal(mu = 0, sigma = a / 2) # for continuous lengthscale
student_t(nu = 4) # for interaction lengthscale
igam(shape = 0.5, scale = 0.005, square = TRUE) # for sigma
}
\seealso{
Other functions related to the inverse-gamma distribution: 
\code{\link{dinvgamma_stanlike}()},
\code{\link{plot_invgamma}()}
}
\concept{functions related to the inverse-gamma distribution}
