% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{get_r_string}
\alias{get_r_string}
\title{Extract text from \code{STR_CONST} nodes}
\usage{
get_r_string(s, xpath = NULL)
}
\arguments{
\item{s}{An input string or strings. If \code{s} is an \code{xml_node} or \code{xml_nodeset} and \code{xpath} is \code{NULL},
extract its string value with \code{\link[xml2:xml_text]{xml2::xml_text()}}. If \code{s} is an \code{xml_node} or \code{xml_nodeset}
and \code{xpath} is specified, it is extracted with \code{\link[xml2:xml_find_all]{xml2::xml_find_chr()}}.}

\item{xpath}{An XPath, passed on to \code{\link[xml2:xml_find_all]{xml2::xml_find_chr()}} after wrapping with \code{string()}.}
}
\description{
Convert \code{STR_CONST} \code{text()} values into R strings. This is useful to account for arbitrary
character literals, e.g. \code{R"------[hello]------"}, which is parsed in R as \code{"hello"}.
It is quite cumbersome to write XPaths allowing for strings like this, so whenever your
linter logic requires testing a \code{STR_CONST} node's value, use this function.
NB: this is also properly vectorized on \code{s}, and accepts a variety of inputs. Empty inputs
will become \code{NA} outputs, which helps ensure that \code{length(get_r_string(s)) == length(s)}.
}
\examples{
tmp <- tempfile()
writeLines("c('a', 'b')", tmp)
expr_as_xml <- get_source_expressions(tmp)$expressions[[1L]]$xml_parsed_content
writeLines(as.character(expr_as_xml))
get_r_string(expr_as_xml, "expr[2]")
get_r_string(expr_as_xml, "expr[3]")
unlink(tmp)

# more importantly, extract raw strings correctly
tmp_raw <- tempfile()
writeLines("c(R'(a\\\\b)', R'--[a\\\\\"\'\"\\\\b]--')", tmp_raw)
expr_as_xml_raw <- get_source_expressions(tmp_raw)$expressions[[1L]]$xml_parsed_content
writeLines(as.character(expr_as_xml_raw))
get_r_string(expr_as_xml_raw, "expr[2]")
get_r_string(expr_as_xml_raw, "expr[3]")
unlink(tmp_raw)

}
