% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parse_netlogo_list.R
\name{parse_netlogo_list}
\alias{parse_netlogo_list}
\title{Parse NetLogo Lists}
\usage{
parse_netlogo_list(x)
}
\arguments{
\item{x}{An \code{\link[checkmate:checkAtomic]{atomic}} object potentially
containing NetLogo-style lists.}
}
\value{
A \code{\link[=list]{list}} of parsed elements if the input contains
NetLogo-style lists; otherwise, returns the original vector.
}
\description{
\code{parse_netlogo_list()} parses NetLogo-style lists represented as strings
(e.g., \code{"[1 2 3]"}) into R lists. It automatically detects
\code{\link[=numeric]{numeric}}, \code{\link[=integer]{integer}}, \code{\link[=logical]{logical}},
and \code{\link[=character]{character}} types within the lists and converts them
accordingly.

If the input does not contain NetLogo-style lists, it returns the original
vector unchanged.
}
\examples{
# Scalar Examples -----

'["a" "b" "c"]' |> parse_netlogo_list()

'[1 2 3]' |> parse_netlogo_list()

'[1.1 2.1 3.1]' |> parse_netlogo_list()

'[true false true]' |> parse_netlogo_list()

# Vector Examples -----

c('["a" "b" "c"]', '["d" "e" "f"]') |> parse_netlogo_list()

c('[1 2 3]', '[4 5 6]') |> parse_netlogo_list()

c('[1.1 2.1 3.1]', '[4.1 5.1 6.1]') |> parse_netlogo_list()

c('[true false true]', '[false true false]') |> parse_netlogo_list()
}
\seealso{
Other Utility functions: 
\code{\link{inspect_experiment_file}()}
}
\concept{Utility functions}
