% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/maxstabtest.R
\name{maxstabtest}
\alias{maxstabtest}
\title{P-P plot for testing max stability}
\usage{
maxstabtest(
  dat,
  m = prod(dim(dat)[-1]),
  nmax = 500L,
  B = 1000L,
  ties.method = "random",
  plot = TRUE
)
}
\arguments{
\item{dat}{matrix or array of max-stable observations, typically block maxima. The first dimension should consist of replicates}

\item{m}{integer indicating how many tuples should be aggregated.}

\item{nmax}{maximum number of pairs. Default to 500L.}

\item{B}{number of nonparametric bootstrap replications. Default to 1000L.}

\item{ties.method}{string indicating the method for \code{\link[base]{rank}}. Default to \code{"random"}.}

\item{plot}{logical indicating whether a graph should be produced (default to \code{TRUE}).}
}
\value{
a Tukey probability-probability plot with 95% confidence intervals obtained using a nonparametric bootstrap
}
\description{
The diagnostic, proposed by Gabda, Towe, Wadsworth and Tawn,
relies on the fact that, for max-stable vectors on the unit Gumbel scale,
the distribution of the maxima is Gumbel distribution with a location parameter equal to the exponent measure.
One can thus consider tuples of size \code{m} and estimate the location parameter via maximum likelihood
and transforming observations to the standard Gumbel scale. Replicates are then pooled and empirical quantiles are defined.
The number of combinations of \code{m} vectors can be prohibitively large, hence only \code{nmax} randomly selected
tuples are selected from all possible combinations. The confidence intervals are obtained by a
nonparametric bootstrap, by resampling observations with replacement observations for the selected tuples and re-estimating the
location parameter. The procedure can be computationally intensive as a result.
}
\references{
Gabda, D.; Towe, R. Wadsworth, J. and J. Tawn, Discussion of ``Statistical Modeling of Spatial Extremes'' by A. C. Davison, S. A. Padoan and M. Ribatet. \emph{Statist. Sci.} \bold{27} (2012), no. 2, 189--192.
}
\keyword{internal}
