% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xdep.R
\name{xdep.chi}
\alias{xdep.chi}
\title{Coefficient of tail correlation}
\usage{
xdep.chi(
  xdat,
  qlev = NULL,
  nq = 40,
  qlim = c(0.8, 0.99),
  estimator = c("emp", "betacop", "gpd", "hill"),
  confint = c("wald", "lrt"),
  level = 0.95,
  margtrans = c("emp", "none"),
  ties.method = "random",
  plot = TRUE,
  ...
)
}
\arguments{
\item{xdat}{an \eqn{n} by \eqn{d} matrix of multivariate observations}

\item{qlev}{vector of percentiles between 0 and 1}

\item{nq}{number of quantiles of the structural variable at which to form a grid; only used if \code{u = NULL}.}

\item{qlim}{limits for the sequence \code{u} of the structural variable}

\item{estimator}{string giving estimator to employ}

\item{confint}{string indicating the type of confidence interval, one of \code{"wald"} or \code{"lrt"}}

\item{level}{the confidence level required (default to 0.95).}

\item{margtrans}{string giving the marginal transformation, one of \code{emp} for rank-based transformation or \code{none} if data are already on the uniform scale}

\item{ties.method}{string indicating the type of method for \code{rank}; see \code{\link[base]{rank}} for a list of options. Default to \code{"random"}}

\item{plot}{logical; if \code{TRUE}, return a plot}

\item{...}{additional arguments to \code{taildep}, currently ignored}
}
\value{
a data frame
\itemize{
\item \code{qlev}: quantile level of estimates
\item \code{coef}: point estimates
\item \code{lower}: lower bound of confidence interval
\item \code{upper}: lower bound of confidence interval
}
}
\description{
The coefficient of tail correlation \eqn{\chi} is
\deqn{\chi = \lim_{u \to 1} \frac{\Pr(F_1(X_1)>u, \ldots, F_D(X_D)>u)}{1-u}.}
Asymptotically independent vectors have \eqn{\chi = 0}. The estimator uses an estimator of the survival copula
}
\examples{
\dontrun{
set.seed(765)
# Max-stable model
dat <- rmev(n = 1000, d = 2, param = 0.7, model = "log")
xdep.chi(dat, confint = 'wald')
}
}
