% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/micer.R
\name{miceCI}
\alias{miceCI}
\title{miceCI}
\usage{
miceCI(
  reps = 200,
  lowPercentile,
  highPercentile,
  reference,
  prediction,
  mappings = levels(as.factor(reference)),
  multiclass = TRUE,
  positiveIndex = 1
)
}
\arguments{
\item{reps}{number of bootstrap replicates to use. Default is 200.}

\item{lowPercentile}{lower percentile for confidence interval. Default is 0.025 for a 95\% CI.}

\item{highPercentile}{upper percentile for confidence interval. Default is 0.975 for a 95\% CI.}

\item{reference}{column of reference labels as factor data type.}

\item{prediction}{column of predicted labels as factor data type.}

\item{mappings}{names of classes (if not provided, factor levels are used).}

\item{multiclass}{TRUE or FALSE. If TRUE, treats classification as multiclass. If FALSE, treats classification as binary. Default is TRUE.}

\item{positiveIndex}{index for positive case for binary classification. Ignored for multiclass classification. Default is 1 or first factor level}
}
\value{
dataframe object of metric name and estimated mean value, median value, and lower and upper CIs.
}
\description{
Calculate confidence intervals (CIs) for MICE and associated metrics using bootstrap sampling and the percentile method.
}
\details{
Confidence intervals are estimated for overall accuracy, MICE, and all class-aggregated, macro-averaged metrics produced by mice() or miceCM().
Returns metric name, mean metric value, median metric value, lower confidence interval bounds (low.ci), and upper confidence interval bounds
(upper.ci) as a dataframe object.
}
\examples{
#Multiclass example
data(mcData)
ciResultsMC <- miceCI(rep=100,
mcData$ref,
mcData$pred,
lowPercentile=0.025,
highPercentile=0.975,
mappings=c("Barren", "Forest", "Impervious", "Low Vegetation", "Mixed Dev", "Water"),
multiclass=TRUE)

print(ciResultsMC)

#Binary example
data(biData)
ciResultsBi <- miceCI(rep=100,
biData$ref,
biData$pred,
lowPercentile=0.025,
highPercentile=0.975,
mappings = c("Mined", "Not Mined"),
multiclass=FALSE,
positiveIndex=1)

print(ciResultsBi)
}
