% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/time_lnCVR.R
\name{.time_interaction_lnCVR}
\alias{.time_interaction_lnCVR}
\title{Log Coefficient of Variation Ratio: Interaction Between Experimental Treatment and Time}
\usage{
.time_interaction_lnCVR(
  t0_Ctrl_mean,
  t0_Ctrl_sd,
  t1_Ctrl_mean,
  t1_Ctrl_sd,
  Ctrl_n,
  Ctrl_cor,
  t0_Exp_mean,
  t0_Exp_sd,
  t1_Exp_mean,
  t1_Exp_sd,
  Exp_n,
  Exp_cor
)
}
\arguments{
\item{t0_Ctrl_mean}{Sample mean from the control group at time 0}

\item{t0_Ctrl_sd}{Standard deviation from the control group at time 0}

\item{t1_Ctrl_mean}{Sample mean from the control group at time 1}

\item{t1_Ctrl_sd}{Standard deviation from the control group at time 1}

\item{Ctrl_n}{Sample size of the control group}

\item{Ctrl_cor}{Correlation between the means of the control group at t0 and t1}

\item{t0_Exp_mean}{Sample mean from the experimental group at time 0}

\item{t0_Exp_sd}{Standard deviation from the experimental group at time 0}

\item{t1_Exp_mean}{Sample mean from the experimental group at time 1}

\item{t1_Exp_sd}{Standard deviation from the experimental group at time 1}

\item{Exp_n}{Sample size of the experimental group}

\item{Exp_cor}{Correlation between the means of the experimental group at t0 and t1}
}
\value{
A data frame containing the effect sizes and their sampling variance.
By default, the columns are named \code{yi} (effect size) and \code{vi} (sampling variance).
If \code{append = TRUE}, the results are appended to the input \code{data}; otherwise, only the computed effect size columns are returned.
}
\description{
Log Coefficient of Variation Ratio: Interaction Between Experimental Treatment and Time
}
\keyword{internal}
