% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diff_two_dep_cors.R
\name{diff_two_dep_cors}
\alias{diff_two_dep_cors}
\title{Difference between two dependent Pearson's correlations (with common index)}
\usage{
diff_two_dep_cors(data, y, x1, x2, level = 0.95, missing = "default")
}
\arguments{
\item{data}{Data frame.}

\item{y}{Character. Variable name of the common index variable.}

\item{x1}{Character. Variable name.}

\item{x2}{Character. Variable name.}

\item{level}{Numeric. The confidence level required for the result output (Default .95)}

\item{missing}{Character. Treatment of missing values (e.g., "ML", default = listwise deletion)}
}
\value{
Parameter estimates from the fitted structural path model.
}
\description{
Calculates Cohen's q effect size statistic for difference between two correlations, r_yx1 and r_yx2.
Tests if Cohen's q is different from zero while accounting for dependency between the two correlations.
}
\examples{
set.seed(3864)
d<-data.frame(y=rnorm(100),x=rnorm(100))
d$x1<-d$x+rnorm(100)
d$x2<-d$x+rnorm(100)
diff_two_dep_cors(data=d,y="y",x1="x1",x2="x2")
}
