% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hirano_flux.R
\name{hirano_flux}
\alias{hirano_flux}
\title{Internal function to compute surface co2 flux at a given timepoint via Hirano et al 2005}
\usage{
hirano_flux(zOffset, co2, co2_err, diffusive, diffusive_err)
}
\arguments{
\item{zOffset}{Required. depths below surface - assumed to be positive in value. Important for directionality!}

\item{co2}{Required. co2 at depth (umol m--1)}

\item{co2_err}{Required. Associated errors with that value of co2}

\item{diffusive}{Required. diffusivity at each depth}

\item{diffusive_err}{Required Associated errors with diffusivity}
}
\value{
Data frame of fluxes associated error
}
\description{
Given  zOffsets, diffusivity, and co2 (umol mol-1) and their associated errors, compute the surface flux. This is done by estimating the surface concentration through linear regression and linear extrapolation of the bottom and top surface fluxes. Modified from Hirano et al (2005).
}
\references{
Hirano, Takashi, Honghyun Kim, and Yumiko Tanaka. 2003. “Long-Term Half-Hourly Measurement of Soil CO2 Concentration and Soil Respiration in a Temperate Deciduous Forest.” Journal of Geophysical Research: Atmospheres 108 (D20). https://doi.org/10.1029/2003JD003766.

Maier, M., and H. Schack-Kirchner. 2014. “Using the Gradient Method to Determine Soil Gas Flux: A Review.” Agricultural and Forest Meteorology 192–193 (July):78–95. https://doi.org/10.1016/j.agrformet.2014.03.006.
}
\seealso{
[dejong_shappert_flux()], [tang_2003_flux()], [tang_2005_flux()] for other ways to compute surface fluxes.
}
\author{
John Zobitz \email{zobitz@augsburg.edu}
}
