% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reprocess_vswc.R
\name{reprocess_vswc}
\alias{reprocess_vswc}
\title{Internal helper function to reprocess SWC data from calibration data}
\usage{
reprocess_vswc(site_name, download_date)
}
\arguments{
\item{site_name}{Required. NEON code for a particular site (a string)}

\item{download_date}{Required. Date where we end getting NEON data. Format: YYYY-MM (can't specify day).  So "2020-05" means it will grab data for the entire 5th month of 2020. (a string). Downloads data for a given month only}
}
\value{
A data frame of startDateTime, horizontalPosition, and the associated QF flag.

A list containing stacked swc data
}
\description{
Apply correct calibration data functions for SWC data - see https://data.neonscience.org/data-products/DP1.00094.001
}
\examples{
\donttest{
out_swc <- reprocess_vswc("SJER","2022-06")
}
}
\author{
John Zobitz \email{zobitz@augsburg.edu},
}
