% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fmt_pct_special.R
\name{fmt_pct_special}
\alias{fmt_pct_special}
\title{Format Numerical Values to Special Percentage Strings}
\usage{
fmt_pct_special(x)
}
\arguments{
\item{x}{A vector of numerical values}
}
\value{
A character vector
}
\description{
This function formats numeric vectors with values between 0 and
1 into percentage strings with special specifications. Those specifications
are:
\itemize{
\item 0 and 1 are converted to "0\%" and "100\%" respectively (takes machine
precision into account)
\item all other values < 0.01 are converted to "<1\%"
\item all other values between 0.01 and 0.995 are rounded to percentages without
decimals
\item values between 0.995 and 0.999 are rounded to percentages with 1 decimal
\item values between 0.999 and 1 are converted to ">99.9\%" unless closer to 1
than machine precision.
}
}
\examples{
x <- c(0, 0.004, 0.009, 0.011, 0.9, 0.98, 0.994,
       .995, .9989, .999, .9991, .99999999)
fmt <- fmt_pct_special(x)
data.frame(x = x, fmt = fmt)
}
