% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulations_verify_fct.R
\name{simulations_verify_fct}
\alias{simulations_verify_fct}
\title{Verify Custom NFL Result Simulation Function}
\usage{
simulations_verify_fct(
  compute_results,
  ...,
  games = nflseedR::sims_games_example,
  teams = nflseedR::sims_teams_example
)
}
\arguments{
\item{compute_results}{A function to compute results of games. See below
detail section for more information on expected behavior.}

\item{...}{Further arguments passed on to \code{compute_results}.}

\item{games}{An NFL schedule where some results are missing. \code{compute_results}
is supposed to compute those results on a weekly base. Defaults to
\link{sims_games_example}. Please see this example to understand
the required data structure.}

\item{teams}{A list of teams by simulation number. This is usually calculated
automatically and not user facing. It can be used to "transport" team information
like elo ratings from one simulated week to the next. Defaults to
\link{sims_teams_example}. Please see this example to understand
the required data structure.}
}
\value{
Returns \code{TRUE} invisibly if no problems are found.
}
\description{
nflseedR supports custom functions to compute results in season simulations
through the argument \code{compute_results} in the season simulation function
\link{nfl_simulations}. To ensure that custom functions work as nflseedR expects
them to, it is recommended to verify their behavior.
This function first checks the structure of the output and then whether game
results are changed as expected. Whenever a problem is found, the function will
error with a hint to the problem (this means that you might be required to
iterate over all problems until the function stops erroring).
See below detail section for more information on expected behavior.
}
\details{
The following sections detail the requirements for the \code{compute_results}
function. If anything is unclear, please see the source code of nflseedR's
default function \code{nflseedR_compute_results}.
\subsection{Required Function Arguments of \code{compute_results}}{

The function passed to \code{compute_results} is required to support the arguments
\code{"teams"}, \code{"games"}, and \code{"week_num"}. The two leading ones are already
described above. The latter is a factor with a length of 1, which identifies
the current week. Regular season weeks are labeled \code{"1"}, \code{"2"}, etc.
Playoff weeks are labeled \code{"WC"}, \code{"DIV"}, \code{"CON"}, and \code{"SB"}.
}

\subsection{Required Output Structure of \code{compute_results}}{

The function passed to \code{compute_results} is required to return a list of the
two objects \code{"teams"} and \code{"games"} as passed to it in the arguments of the
same name. The function must not remove rows or columns.
So the last line of \code{compute_results} usually looks like

\if{html}{\out{<div class="sourceCode">}}\preformatted{list("teams" = teams, "games" = games)
}\if{html}{\out{</div>}}
}

\subsection{Required Behavior of \code{compute_results} when Computing Game Results}{

nflseedR calls \code{compute_results} for every week where a \code{result} is missing
in \code{games}. The variable \code{result} is defined as the point differential between
the home team and the away team. If the home team loses, the value is
therefore < 0, if it wins > 0 and if it ties == 0.
To support elo-based simulations, this is done in a loop so that elo ratings
can be updated based on the results and "transported" from week to week. You
can "transport" ratings or other information by joining them to the \code{"teams"}
table.
This behavior requires that \code{compute_results} only changes the results of
the current week - called \code{week_num}. And only if there is not already a
result.
So \code{compute_results} must only compute a result when

\if{html}{\out{<div class="sourceCode">}}\preformatted{week == week_num & is.na(result)
}\if{html}{\out{</div>}}

For the playoffs, there is also the special case that matches cannot end in a
tie (\code{result == 0}). In most cases, ties are not simulated anyway because
they occur so rarely. But in the event that they are simulated, they must
not be in the playoffs.
}
}
\examples{
simulations_verify_fct(nflseedR_compute_results)
}
