% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evaluate.R
\name{different_rel}
\alias{different_rel}
\title{Estimate reliability across multiple window widths and age steps}
\usage{
different_rel(
  data,
  item_variables,
  age_name,
  step_window,
  min_agegroup = NULL,
  max_agegroup = NULL,
  step_agegroup,
  include_window_per_person = FALSE,
  complete.obs = TRUE
)
}
\arguments{
\item{data}{data.frame containing item scores and age variable.}

\item{item_variables}{character vector. Names of the columns with item scores.}

\item{age_name}{string. Name of the age variable. Default is \code{"age_years"}.}

\item{step_window}{numeric vector. Window widths to evaluate.}

\item{min_agegroup}{numeric. Minimum age to include. Defaults to the floor of the minimum age in the data.}

\item{max_agegroup}{numeric. Maximum age to include. Defaults to the ceiling of the maximum age in the data.}

\item{step_agegroup}{numeric vector. Step sizes between evaluated age points.}

\item{include_window_per_person}{logical. If \code{TRUE}, also estimates reliability for each individual. Default is \code{FALSE}.}

\item{complete.obs}{logical. If \code{TRUE} (default), uses listwise deletion; if \code{FALSE}, uses pairwise deletion.}
}
\value{
An object of class \code{Drel} (a data.frame) with:
\itemize{
\item \code{rel}: Reliability estimates
\item \code{age}: Corresponding evaluated ages
\item \code{window_width}: Width of the window used
\item \code{age_group_width}: Step size between evaluated age groups
\item \code{version}: Type of estimation (\code{"step"} or \code{"window_per_person"})
}
}
\description{
Estimates reliability curves across various combinations of window widths and age step sizes,
with optional per-individual estimation.
}
\examples{
\donttest{
invisible(data("ids_kn_data"))
rel_int <- different_rel(
  data = ids_kn_data,
  item_variables = colnames(ids_kn_data),
  age_name = "age_years",
  step_window = c(0.5, 1, 2, 5, 10, 20),
  min_agegroup = 5,
  max_agegroup = 20,
  step_agegroup = c(0.5, 1, 1.5, 2)
)
}

}
\seealso{
\code{\link[=plot_drel]{plot_drel()}}
}
