% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mockMeasurement.R
\name{mockMeasurement}
\alias{mockMeasurement}
\title{Generates a mock measurement table and integrates it into an existing CDM object.}
\usage{
mockMeasurement(cdm, recordPerson = 1, seed = NULL)
}
\arguments{
\item{cdm}{A \code{cdm_reference} object that must already include 'person' and 'observation_period' tables.
This object serves as the base CDM structure where the measurement data will be added.
The 'person' and 'observation_period' tables must be populated as they are necessary for generating accurate measurement records.}

\item{recordPerson}{An integer specifying the expected number of measurement records to generate per person.
This parameter allows for the simulation of varying frequencies of health measurements among individuals in the cohort,
reflecting real-world variability in patient monitoring and diagnostic testing.}

\item{seed}{An optional integer used to set the seed for random number generation, ensuring reproducibility of the generated data.
If provided, this seed enables the function to produce consistent results each time it is run with the same inputs.
If 'NULL', the seed is not set, which can lead to different outputs on each run.}
}
\value{
Returns the modified \code{cdm} object with the new 'measurement' table added. This table includes the simulated
measurement data for each person, ensuring that each record is correctly linked to individuals in the 'person' table
and falls within valid observation periods.
}
\description{
This function simulates measurement records for individuals within a specified cohort. It creates a realistic dataset by generating measurement records based on the specified number of records per person. Each measurement record is correctly associated with an individual within valid observation periods, ensuring the integrity of the data.
}
\examples{
library(omock)

# Create a mock CDM reference and add measurement records
cdm <- mockCdmReference() |>
  mockPerson() |>
  mockObservationPeriod() |>
  mockMeasurement(recordPerson = 5)

# View the generated measurement data
print(cdm$measurement)
}
