% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metadata.R
\name{orderly_strict_mode}
\alias{orderly_strict_mode}
\title{Enable orderly strict mode}
\usage{
orderly_strict_mode()
}
\value{
Undefined
}
\description{
Put orderly into "strict mode", which is closer to the defaults
in orderly 1.0.0; in this mode only explicitly included files (via
\code{\link[=orderly_resource]{orderly_resource()}} and
\code{\link[=orderly_shared_resource]{orderly_shared_resource()}}) are copied when running a
packet, and we warn about any unexpected files at the end of the
run.  Using strict mode allows orderly to be more aggressive in
how it deletes files within the source directory, more accurate in
what it reports to you, and faster to start packets after
developing them interactively.
}
\details{
In future, we may extend strict mode to allow requiring that no
computation occurs within orderly functions (i.e., that the
requirements to run a packet are fully known before actually
running it).  Most likely this will \emph{not} be the default behaviour
and \code{orderly_strict_mode()} will gain an argument.

We will allow server processes to either override this value
(enabling it even when it is not explicitly given) and/or require
it.
}
\examples{
# An example in context within the orderly examples:
orderly_example_show("strict")
}
