% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_describe_capacity_block_extension_offerings}
\alias{ec2_describe_capacity_block_extension_offerings}
\title{Describes Capacity Block extension offerings available for purchase in
the Amazon Web Services Region that you're currently using}
\usage{
ec2_describe_capacity_block_extension_offerings(
  DryRun = NULL,
  CapacityBlockExtensionDurationHours,
  CapacityReservationId,
  NextToken = NULL,
  MaxResults = NULL
)
}
\arguments{
\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}

\item{CapacityBlockExtensionDurationHours}{[required] The duration of the Capacity Block extension offering in hours.}

\item{CapacityReservationId}{[required] The ID of the Capacity reservation to be extended.}

\item{NextToken}{The token to use to retrieve the next page of results.}

\item{MaxResults}{The maximum number of items to return for this request. To get the next
page of items, make another request with the token returned in the
output. For more information, see
\href{https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Query-Requests.html#api-pagination}{Pagination}.}
}
\description{
Describes Capacity Block extension offerings available for purchase in the Amazon Web Services Region that you're currently using.

See \url{https://www.paws-r-sdk.com/docs/ec2_describe_capacity_block_extension_offerings/} for full documentation.
}
\keyword{internal}
