% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/proton_operations.R
\name{proton_create_environment_template_version}
\alias{proton_create_environment_template_version}
\title{Create a new major or minor version of an environment template}
\usage{
proton_create_environment_template_version(
  clientToken = NULL,
  description = NULL,
  majorVersion = NULL,
  source,
  tags = NULL,
  templateName
)
}
\arguments{
\item{clientToken}{When included, if two identical requests are made with the same client
token, Proton returns the environment template version that the first
request created.}

\item{description}{A description of the new version of an environment template.}

\item{majorVersion}{To create a new minor version of the environment template, include
\verb{major Version}.

To create a new major and minor version of the environment template,
exclude \verb{major Version}.}

\item{source}{[required] An object that includes the template bundle S3 bucket path and name for
the new version of an template.}

\item{tags}{An optional list of metadata items that you can associate with the
Proton environment template version. A tag is a key-value pair.

For more information, see \href{https://docs.aws.amazon.com/proton/latest/userguide/resources.html}{Proton resources and tagging}
in the \emph{Proton User Guide}.}

\item{templateName}{[required] The name of the environment template.}
}
\description{
Create a new major or minor version of an environment template. A major version of an environment template is a version that \emph{isn't} backwards compatible. A minor version of an environment template is a version that's backwards compatible within its major version.

See \url{https://www.paws-r-sdk.com/docs/proton_create_environment_template_version/} for full documentation.
}
\keyword{internal}
